/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.JdiExceptionReference;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionInfoRequestHandler
implements IDebugRequestHandler {
    protected final Logger logger;

    public ExceptionInfoRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.EXCEPTIONINFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Object object;
        Requests.ExceptionInfoArguments exceptionInfoArguments = (Requests.ExceptionInfoArguments)arguments;
        ThreadReference threadReference = DebugUtility.getThread(iDebugAdapterContext.getDebugSession(), exceptionInfoArguments.threadId);
        if (threadReference == null) {
            throw AdapterUtils.createCompletionException("Thread " + exceptionInfoArguments.threadId + " doesn't exist.", ErrorCode.EXCEPTION_INFO_FAILURE);
        }
        JdiExceptionReference jdiExceptionReference = iDebugAdapterContext.getExceptionManager().getException(exceptionInfoArguments.threadId);
        if (jdiExceptionReference == null) {
            throw AdapterUtils.createCompletionException("No exception exists in thread " + exceptionInfoArguments.threadId, ErrorCode.EXCEPTION_INFO_FAILURE);
        }
        Object object2 = null;
        Object object3 = jdiExceptionReference.exception.referenceType().allMethods().iterator();
        while (object3.hasNext()) {
            object = object3.next();
            if (!Objects.equals("toString", object.name()) || !Objects.equals("()Ljava/lang/String;", object.signature())) continue;
            object2 = object;
            break;
        }
        object = object3 = jdiExceptionReference.exception.type().name();
        if (object2 != null) {
            try {
                Value value = jdiExceptionReference.exception.invokeMethod(threadReference, (Method)object2, Collections.EMPTY_LIST, 1);
                object = value.toString();
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException exception) {
                this.logger.log(Level.SEVERE, String.format("Failed to get the return value of the method Exception.toString(): %s", exception.toString(), exception));
            }
            finally {
                try {
                    iDebugAdapterContext.getStackFrameManager().reloadStackFrames(threadReference);
                }
                catch (Exception exception) {}
            }
        }
        response.body = new Responses.ExceptionInfoResponse((String)object3, (String)object, jdiExceptionReference.isUncaught ? Types.ExceptionBreakMode.USERUNHANDLED : Types.ExceptionBreakMode.ALWAYS);
        return CompletableFuture.completedFuture(response);
    }
}

