/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.formatter;

import com.microsoft.java.debug.core.adapter.formatter.IValueFormatter;
import com.microsoft.java.debug.core.adapter.formatter.ObjectFormatter;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StringObjectFormatter
extends ObjectFormatter
implements IValueFormatter {
    public static final String MAX_STRING_LENGTH_OPTION = "max_string_length";
    private static final int DEFAULT_MAX_STRING_LENGTH = 0;
    private static final String QUOTE_STRING = "\"";

    public StringObjectFormatter() {
        super(null);
    }

    @Override
    public Map<String, Object> getDefaultOptions() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(MAX_STRING_LENGTH_OPTION, 0);
        return hashMap;
    }

    @Override
    public String toString(Object object, Map<String, Object> map) {
        int n = StringObjectFormatter.getMaxStringLength(map);
        return String.format("\"%s\"", n > 0 ? StringUtils.abbreviate((String)((StringReference)object).value(), (int)n) : ((StringReference)object).value());
    }

    @Override
    public boolean acceptType(Type type, Map<String, Object> map) {
        return type != null && (type.signature().charAt(0) == 's' || type.signature().equals("Ljava/lang/String;"));
    }

    @Override
    public Value valueOf(String string, Type type, Map<String, Object> map) {
        if (string == null || "null".equals(string)) {
            return null;
        }
        if (string.length() >= 2 && string.startsWith(QUOTE_STRING) && string.endsWith(QUOTE_STRING)) {
            return type.virtualMachine().mirrorOf(StringUtils.substring((String)string, (int)1, (int)-1));
        }
        return type.virtualMachine().mirrorOf(string);
    }

    private static int getMaxStringLength(Map<String, Object> map) {
        return map.containsKey(MAX_STRING_LENGTH_OPTION) ? (Integer)map.get(MAX_STRING_LENGTH_OPTION) : 0;
    }
}

