/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.formatter;

import com.microsoft.java.debug.core.adapter.formatter.NumericFormatter;
import com.microsoft.java.debug.core.adapter.formatter.ObjectFormatter;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Map;
import java.util.function.BiFunction;

public class ArrayObjectFormatter
extends ObjectFormatter {
    public ArrayObjectFormatter(BiFunction<Type, Map<String, Object>, String> biFunction) {
        super(biFunction);
    }

    @Override
    protected String getPrefix(ObjectReference objectReference, Map<String, Object> map) {
        String string = String.format("[%s]", NumericFormatter.formatNumber(ArrayObjectFormatter.arrayLength(objectReference), map));
        return super.getPrefix(objectReference, map).replaceFirst("\\[]", string);
    }

    @Override
    public boolean acceptType(Type type, Map<String, Object> map) {
        return type != null && type.signature().charAt(0) == '[';
    }

    private static int arrayLength(Value value) {
        return ((ArrayReference)value).length();
    }
}

