/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.adapter.IStepFilterProvider;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import org.apache.commons.lang3.ArrayUtils;

public class StepFilterProvider
implements IStepFilterProvider {
    @Override
    public boolean shouldSkipOver(Method method, Requests.StepFilters stepFilters) {
        if (!this.isConfigured(stepFilters)) {
            return false;
        }
        return stepFilters.skipStaticInitializers && method.isStaticInitializer() || stepFilters.skipSynthetics && method.isSynthetic() || stepFilters.skipConstructors && method.isConstructor();
    }

    @Override
    public boolean shouldSkipOut(Location location, Method method) {
        return false;
    }

    private boolean isConfigured(Requests.StepFilters stepFilters) {
        if (stepFilters == null) {
            return false;
        }
        return ArrayUtils.isNotEmpty((Object[])stepFilters.allowClasses) || ArrayUtils.isNotEmpty((Object[])stepFilters.skipClasses) || ArrayUtils.isNotEmpty((Object[])stepFilters.classNameFilters) || stepFilters.skipConstructors || stepFilters.skipStaticInitializers || stepFilters.skipSynthetics;
    }
}

