/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.adapter.IStackFrameManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StackFrameManager
implements IStackFrameManager {
    private Map<Long, StackFrame[]> threadStackFrameMap = Collections.synchronizedMap(new HashMap());

    @Override
    public StackFrame getStackFrame(StackFrameReference stackFrameReference) {
        ThreadReference threadReference = stackFrameReference.getThread();
        int n = stackFrameReference.getDepth();
        StackFrame[] stackFrameArray = this.threadStackFrameMap.get(threadReference.uniqueID());
        return stackFrameArray == null || stackFrameArray.length < n ? null : stackFrameArray[n];
    }

    @Override
    public StackFrame[] reloadStackFrames(ThreadReference threadReference) {
        return this.threadStackFrameMap.compute(threadReference.uniqueID(), (l, stackFrameArray) -> {
            try {
                return threadReference.frames().toArray(new StackFrame[0]);
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                return new StackFrame[0];
            }
        });
    }
}

