/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.protocol.Events;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;

public class ProcessConsole {
    private InputStreamObservable stdoutStream;
    private InputStreamObservable stderrStream;
    private Observable<ConsoleMessage> observable = null;

    public ProcessConsole(Process process) {
        this(process, "Process", StandardCharsets.UTF_8);
    }

    public ProcessConsole(Process process, String string2, Charset charset) {
        this.stdoutStream = new InputStreamObservable(string2 + " Stdout Handler", process.getInputStream(), charset);
        this.stderrStream = new InputStreamObservable(string2 + " Stderr Handler", process.getErrorStream(), charset);
        Observable observable = this.stdoutStream.messages().map(string -> new ConsoleMessage((String)string, Events.OutputEvent.Category.stdout));
        Observable observable2 = this.stderrStream.messages().map(string -> new ConsoleMessage((String)string, Events.OutputEvent.Category.stderr));
        this.observable = Observable.mergeArrayDelayError((ObservableSource[])new ObservableSource[]{observable, observable2}).observeOn(Schedulers.newThread());
    }

    public void start() {
        this.stdoutStream.start();
        this.stderrStream.start();
    }

    public void stop() {
        this.stdoutStream.stop();
        this.stderrStream.stop();
    }

    public Observable<ConsoleMessage> messages() {
        return this.observable;
    }

    public Observable<ConsoleMessage> stdoutMessages() {
        return this.messages().filter(consoleMessage -> consoleMessage.category == Events.OutputEvent.Category.stdout);
    }

    public Observable<ConsoleMessage> stderrMessages() {
        return this.messages().filter(consoleMessage -> consoleMessage.category == Events.OutputEvent.Category.stderr);
    }

    public Observable<ConsoleMessage> lineMessages() {
        return this.messages().map(consoleMessage -> {
            String[] stringArray = consoleMessage.output.split("(?<=\n)");
            return (ConsoleMessage[])Stream.of(stringArray).map(string -> new ConsoleMessage((String)string, consoleMessage.category)).toArray(ConsoleMessage[]::new);
        }).concatMap(consoleMessageArray -> Observable.fromArray((Object[])consoleMessageArray));
    }

    public static class ConsoleMessage {
        public String output;
        public Events.OutputEvent.Category category;

        public ConsoleMessage(String string, Events.OutputEvent.Category category) {
            this.output = string;
            this.category = category;
        }
    }

    public static class InputStreamObservable {
        private PublishSubject<String> rxSubject = PublishSubject.create();
        private String name;
        private InputStream inputStream;
        private Charset encoding;
        private Thread loopingThread;

        public InputStreamObservable(String string, InputStream inputStream, Charset charset) {
            this.name = string;
            this.inputStream = inputStream;
            this.encoding = charset;
        }

        public void start() {
            this.loopingThread = new Thread(this.name){

                @Override
                public void run() {
                    this.monitor(inputStream, (PublishSubject<String>)rxSubject);
                }
            };
            this.loopingThread.setDaemon(true);
            this.loopingThread.start();
        }

        public void stop() {
            if (this.loopingThread != null) {
                this.loopingThread.interrupt();
                this.loopingThread = null;
            }
        }

        private void monitor(InputStream inputStream, PublishSubject<String> publishSubject) {
            BufferedReader bufferedReader = new BufferedReader(this.encoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.encoding));
            char[] cArray = new char[4096];
            try {
                while (true) {
                    if (Thread.interrupted()) {
                        publishSubject.onComplete();
                        return;
                    }
                    int n = bufferedReader.read(cArray, 0, 4096);
                    if (n == -1) {
                        publishSubject.onComplete();
                        return;
                    }
                    publishSubject.onNext((Object)new String(cArray, 0, n));
                }
            }
            catch (IOException iOException) {
                publishSubject.onError((Throwable)iOException);
                return;
            }
        }

        public Observable<String> messages() {
            return this.rxSubject;
        }
    }
}

