/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import java.util.Arrays;

public enum ErrorCode {
    UNKNOWN_FAILURE(1000),
    UNRECOGNIZED_REQUEST_FAILURE(1001),
    LAUNCH_FAILURE(1002),
    ATTACH_FAILURE(1003),
    ARGUMENT_MISSING(1004),
    SET_BREAKPOINT_FAILURE(1005),
    SET_EXCEPTIONBREAKPOINT_FAILURE(1006),
    GET_STACKTRACE_FAILURE(1007),
    GET_VARIABLE_FAILURE(1008),
    SET_VARIABLE_FAILURE(1009),
    EVALUATE_FAILURE(1010),
    EMPTY_DEBUG_SESSION(1011),
    INVALID_ENCODING(1012),
    VM_TERMINATED(1013),
    LAUNCH_IN_TERMINAL_FAILURE(1014),
    STEP_FAILURE(1015),
    RESTARTFRAME_FAILURE(1016),
    COMPLETIONS_FAILURE(1017),
    EXCEPTION_INFO_FAILURE(1018),
    EVALUATION_COMPILE_ERROR(2001),
    EVALUATE_NOT_SUSPENDED_THREAD(2002),
    HCR_FAILURE(3001);

    private int id;

    private ErrorCode(int n2) {
        this.id = n2;
    }

    public int getId() {
        return this.id;
    }

    public static ErrorCode parse(int n) {
        ErrorCode[] errorCodeArray = (ErrorCode[])Arrays.stream(ErrorCode.values()).filter(errorCode -> errorCode.getId() == n).toArray(ErrorCode[]::new);
        if (errorCodeArray.length > 0) {
            return errorCodeArray[0];
        }
        return UNKNOWN_FAILURE;
    }
}

