/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IWatchpoint;
import com.microsoft.java.debug.core.adapter.IBreakpointManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BreakpointManager
implements IBreakpointManager {
    private final Logger logger;
    private List<IBreakpoint> breakpoints;
    private Map<String, HashMap<String, IBreakpoint>> sourceToBreakpoints;
    private Map<String, IWatchpoint> watchpoints;
    private AtomicInteger nextBreakpointId = new AtomicInteger(1);

    public BreakpointManager(Logger logger) {
        this.logger = logger;
        this.breakpoints = Collections.synchronizedList(new ArrayList(5));
        this.sourceToBreakpoints = new HashMap<String, HashMap<String, IBreakpoint>>();
        this.watchpoints = new HashMap<String, IWatchpoint>();
    }

    @Override
    public IBreakpoint[] setBreakpoints(String string, IBreakpoint[] iBreakpointArray) {
        return this.setBreakpoints(string, iBreakpointArray, false);
    }

    @Override
    public IBreakpoint[] setBreakpoints(String string, IBreakpoint[] iBreakpointArray, boolean bl) {
        ArrayList<IBreakpoint> arrayList = new ArrayList<IBreakpoint>();
        HashMap<String, IBreakpoint> hashMap = this.sourceToBreakpoints.get(string);
        if (bl && hashMap != null) {
            for (IBreakpoint object2 : hashMap.values()) {
                try {
                    object2.close();
                }
                catch (Exception arrayList3) {
                    this.logger.log(Level.SEVERE, String.format("Remove breakpoint exception: %s", arrayList3.toString()), arrayList3);
                }
                this.breakpoints.remove(object2);
            }
            this.sourceToBreakpoints.put(string, null);
            hashMap = null;
        }
        if (hashMap == null) {
            hashMap = new HashMap();
            this.sourceToBreakpoints.put(string, hashMap);
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (IBreakpoint iBreakpoint : iBreakpointArray) {
            IBreakpoint iBreakpoint2 = hashMap.get(String.valueOf(iBreakpoint.getLineNumber()));
            if (iBreakpoint2 != null) {
                arrayList.add(iBreakpoint2);
                arrayList3.add(iBreakpoint2.getLineNumber());
                continue;
            }
            arrayList.add(iBreakpoint);
            arrayList2.add(iBreakpoint);
        }
        ArrayList arrayList4 = new ArrayList();
        for (IBreakpoint iBreakpoint : hashMap.values()) {
            if (arrayList3.contains(iBreakpoint.getLineNumber())) continue;
            arrayList4.add(iBreakpoint);
        }
        this.removeBreakpointsInternally(string, arrayList4.toArray(new IBreakpoint[0]));
        this.addBreakpointsInternally(string, arrayList2.toArray(new IBreakpoint[0]));
        return arrayList.toArray(new IBreakpoint[0]);
    }

    private void addBreakpointsInternally(String string2, IBreakpoint[] iBreakpointArray) {
        Map map = this.sourceToBreakpoints.computeIfAbsent(string2, string -> new HashMap());
        if (iBreakpointArray != null && iBreakpointArray.length > 0) {
            for (IBreakpoint iBreakpoint : iBreakpointArray) {
                iBreakpoint.putProperty("id", this.nextBreakpointId.getAndIncrement());
                this.breakpoints.add(iBreakpoint);
                map.put(String.valueOf(iBreakpoint.getLineNumber()), iBreakpoint);
            }
        }
    }

    private void removeBreakpointsInternally(String string, IBreakpoint[] iBreakpointArray) {
        Map map = this.sourceToBreakpoints.get(string);
        if (map == null || map.isEmpty() || iBreakpointArray.length == 0) {
            return;
        }
        for (IBreakpoint iBreakpoint : iBreakpointArray) {
            if (!this.breakpoints.contains(iBreakpoint)) continue;
            try {
                iBreakpoint.close();
                this.breakpoints.remove(iBreakpoint);
                map.remove(String.valueOf(iBreakpoint.getLineNumber()));
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, String.format("Remove breakpoint exception: %s", exception.toString()), exception);
            }
        }
    }

    @Override
    public IBreakpoint[] getBreakpoints() {
        return this.breakpoints.toArray(new IBreakpoint[0]);
    }

    @Override
    public IBreakpoint[] getBreakpoints(String string) {
        HashMap<String, IBreakpoint> hashMap = this.sourceToBreakpoints.get(string);
        if (hashMap == null) {
            return new IBreakpoint[0];
        }
        return hashMap.values().toArray(new IBreakpoint[0]);
    }

    @Override
    public IWatchpoint[] setWatchpoints(IWatchpoint[] iWatchpointArray) {
        ArrayList<IWatchpoint> arrayList = new ArrayList<IWatchpoint>();
        ArrayList<IWatchpoint> arrayList2 = new ArrayList<IWatchpoint>();
        ArrayList<IWatchpoint> arrayList3 = new ArrayList<IWatchpoint>();
        HashSet<String> hashSet = new HashSet<String>();
        for (IWatchpoint iWatchpoint : iWatchpointArray) {
            if (iWatchpoint == null) {
                arrayList.add(iWatchpoint);
                continue;
            }
            String string = this.getWatchpointKey(iWatchpoint);
            IWatchpoint iWatchpoint2 = this.watchpoints.get(string);
            if (iWatchpoint2 != null && Objects.equals(iWatchpoint2.accessType(), iWatchpoint.accessType())) {
                hashSet.add(string);
                arrayList.add(iWatchpoint2);
                continue;
            }
            arrayList2.add(iWatchpoint);
            arrayList.add(iWatchpoint);
        }
        for (IWatchpoint iWatchpoint : this.watchpoints.values()) {
            if (hashSet.contains(this.getWatchpointKey(iWatchpoint))) continue;
            arrayList3.add(iWatchpoint);
        }
        for (IWatchpoint iWatchpoint : arrayList3) {
            try {
                iWatchpoint.close();
                this.watchpoints.remove(this.getWatchpointKey(iWatchpoint));
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, String.format("Remove the watch point exception: %s", exception.toString()), exception);
            }
        }
        for (IWatchpoint iWatchpoint : arrayList2) {
            iWatchpoint.putProperty("id", this.nextBreakpointId.getAndIncrement());
            this.watchpoints.put(this.getWatchpointKey(iWatchpoint), iWatchpoint);
        }
        return arrayList.toArray(new IWatchpoint[0]);
    }

    private String getWatchpointKey(IWatchpoint iWatchpoint) {
        return iWatchpoint.className() + "#" + iWatchpoint.fieldName();
    }

    @Override
    public IWatchpoint[] getWatchpoints() {
        return (IWatchpoint[])this.watchpoints.values().stream().filter(iWatchpoint -> iWatchpoint != null).toArray(IWatchpoint[]::new);
    }
}

