/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.UsageDataSession;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class UsageDataStore {
    private ConcurrentLinkedQueue<Object> queue = new ConcurrentLinkedQueue();
    private static final int QUEUE_MAX_SIZE = 10000;
    private static final String DEBUG_SESSION_ID_NAME = "debugSessionId";
    private static final String DESCRIPTION_NAME = "description";
    private static final String ERROR_MESSAGE_NAME = "message";
    private static final String STACKTRACE_NAME = "stackTrace";
    private static final String SCOPE_NAME = "scope";
    private static final String TIMESTAMP_NAME = "timestamp";

    private UsageDataStore() {
    }

    public synchronized Object[] fetchAll() {
        Object[] objectArray = this.queue.toArray();
        this.queue.clear();
        return objectArray;
    }

    public static UsageDataStore getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void logSessionData(String string, Map<String, String> map) {
        if (this.queue == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SCOPE_NAME, "session");
        hashMap.put(DEBUG_SESSION_ID_NAME, UsageDataSession.getSessionGuid());
        if (string != null) {
            hashMap.put(DESCRIPTION_NAME, string);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        this.enqueue(hashMap);
    }

    public void logErrorData(String string, Throwable throwable) {
        if (this.queue == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SCOPE_NAME, "exception");
        hashMap.put(DEBUG_SESSION_ID_NAME, UsageDataSession.getSessionGuid());
        if (string != null) {
            hashMap.put(DESCRIPTION_NAME, string);
        }
        if (throwable != null) {
            hashMap.put(ERROR_MESSAGE_NAME, throwable.getMessage());
            hashMap.put(STACKTRACE_NAME, JsonUtils.toJson(throwable.getStackTrace()));
        }
        this.enqueue(hashMap);
    }

    private synchronized void enqueue(Map<String, String> map) {
        if (this.queue.size() > 10000) {
            this.queue.poll();
        }
        if (map != null) {
            map.put(TIMESTAMP_NAME, Instant.now().toString());
            this.queue.add(map);
        }
    }

    private static final class SingletonHolder {
        private static final UsageDataStore INSTANCE = new UsageDataStore();

        private SingletonHolder() {
        }
    }
}

