/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.google.gson.JsonElement;
import com.microsoft.java.debug.core.LoggerFactory;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.sun.jdi.event.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UsageDataSession {
    private final Logger logger;
    private final Logger usageDataLogger;
    private static final long RESPONSE_MAX_DELAY_MS = 1000L;
    private static final ThreadLocal<UsageDataSession> threadLocal = new InheritableThreadLocal<UsageDataSession>();
    private final String sessionGuid = UUID.randomUUID().toString();
    private boolean jdiEventSequenceEnabled = false;
    private long startAt = -1L;
    private long stopAt = -1L;
    private Map<String, Integer> commandCountMap = new HashMap<String, Integer>();
    private Map<String, Integer> breakpointCountMap = new HashMap<String, Integer>();
    private Map<Integer, RequestEvent> requestEventMap = new HashMap<Integer, RequestEvent>();
    private Map<String, Integer> userErrorCount = new HashMap<String, Integer>();
    private Map<String, Integer> commandPerfCountMap = new HashMap<String, Integer>();
    private List<String> eventList = new ArrayList<String>();

    public static String getSessionGuid() {
        return threadLocal.get() == null ? "" : UsageDataSession.threadLocal.get().sessionGuid;
    }

    public static UsageDataSession currentSession() {
        return threadLocal.get();
    }

    public UsageDataSession(Logger logger, LoggerFactory loggerFactory) {
        this.logger = logger;
        this.usageDataLogger = loggerFactory.create("java-debug-usage-data");
        threadLocal.set(this);
    }

    public void reportStart() {
        this.startAt = System.currentTimeMillis();
    }

    public void reportStop() {
        this.stopAt = System.currentTimeMillis();
    }

    public void recordRequest(Messages.Request request) {
        try {
            this.requestEventMap.put(request.seq, new RequestEvent(request, System.currentTimeMillis()));
            this.commandCountMap.put(request.command, this.commandCountMap.getOrDefault(request.command, 0) + 1);
            if ("setBreakpoints".equals(request.command)) {
                String string = "unknown file";
                JsonElement jsonElement = request.arguments.get("source").getAsJsonObject().get("path");
                JsonElement jsonElement2 = request.arguments.get("source").getAsJsonObject().get("name");
                if (jsonElement != null) {
                    string = jsonElement.getAsString();
                } else if (jsonElement2 != null) {
                    string = jsonElement2.getAsString();
                }
                String string2 = AdapterUtils.getSHA256HexDigest(string);
                int n = request.arguments.get("breakpoints").getAsJsonArray().size();
                this.breakpointCountMap.put(string2, this.breakpointCountMap.getOrDefault(string2, 0) + n);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void recordResponse(Messages.Response response) {
        try {
            long l;
            long l2 = l = System.currentTimeMillis();
            String string2 = null;
            RequestEvent requestEvent = this.requestEventMap.getOrDefault(response.request_seq, null);
            if (requestEvent != null) {
                string2 = requestEvent.request.command;
                l2 = requestEvent.timestamp;
                this.requestEventMap.remove(response.request_seq);
            }
            long l3 = l - l2;
            this.commandPerfCountMap.compute(string2, (string, n) -> (n == null ? 0 : n) + (int)l3);
            if (!response.success || l3 > 1000L) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("duration", l3);
                hashMap.put("command", string2);
                hashMap.put("success", response.success);
                this.usageDataLogger.log(Level.WARNING, "abnormal response", hashMap);
                this.jdiEventSequenceEnabled = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitUsageData() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("sessionStartAt", String.valueOf(this.startAt));
        hashMap.put("sessionStopAt", String.valueOf(this.stopAt));
        hashMap.put("commandCount", JsonUtils.toJson(this.commandCountMap));
        hashMap.put("breakpointCount", JsonUtils.toJson(this.breakpointCountMap));
        hashMap.put("userErrorCount", JsonUtils.toJson(this.userErrorCount));
        hashMap.put("commandPerfCount", JsonUtils.toJson(this.commandPerfCountMap));
        if (this.jdiEventSequenceEnabled) {
            List<String> list = this.eventList;
            synchronized (list) {
                hashMap.put("jdiEventSequence", JsonUtils.toJson(this.eventList));
            }
        }
        this.usageDataLogger.log(Level.INFO, "session usage data summary", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEvent(Event event) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
            hashMap.put("event", event.toString());
            List<String> list = this.eventList;
            synchronized (list) {
                this.eventList.add(JsonUtils.toJson(hashMap));
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, String.format("Exception on recording event: %s.", exception.toString()), exception);
        }
    }

    public void recordUserError(ErrorCode errorCode) {
        try {
            String string = errorCode.name();
            this.userErrorCount.put(string, this.userErrorCount.getOrDefault(string, 0) + 1);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, String.format("Exception on recording user error: %s.", exception.toString()), exception);
        }
    }

    public static void enableJdiEventSequence() {
        try {
            UsageDataSession usageDataSession = threadLocal.get();
            if (usageDataSession != null) {
                usageDataSession.jdiEventSequenceEnabled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class RequestEvent {
        Messages.Request request;
        long timestamp;

        RequestEvent(Messages.Request request, long l) {
            this.request = request;
            this.timestamp = l;
        }
    }
}

