/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.google.gson.JsonSyntaxException;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Requests;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class DebugSettings {
    private static Set<IDebugSettingChangeListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static DebugSettings current = new DebugSettings();
    public int maxStringLength = 0;
    public int numericPrecision = 0;
    public boolean showStaticVariables = false;
    public boolean showQualifiedNames = false;
    public boolean showHex = false;
    public boolean showLogicalStructure = true;
    public boolean showToString = true;
    public String logLevel;
    public String javaHome;
    public HotCodeReplace hotCodeReplace = HotCodeReplace.MANUAL;
    public Requests.StepFilters stepFilters = new Requests.StepFilters();
    public Requests.ClassFilters exceptionFilters = new Requests.ClassFilters();
    public boolean exceptionFiltersUpdated = false;
    public int limitOfVariablesPerJdwpRequest = 100;
    public int jdwpRequestTimeout = 3000;

    public static DebugSettings getCurrent() {
        return current;
    }

    public void updateSettings(String string) throws JsonSyntaxException {
        DebugSettings debugSettings = current;
        current = JsonUtils.fromJson(string, DebugSettings.class);
        for (IDebugSettingChangeListener iDebugSettingChangeListener : listeners) {
            iDebugSettingChangeListener.update(debugSettings, current);
        }
    }

    private DebugSettings() {
    }

    public static boolean addDebugSettingChangeListener(IDebugSettingChangeListener iDebugSettingChangeListener) {
        return listeners.add(iDebugSettingChangeListener);
    }

    public static boolean removeDebugSettingChangeListener(IDebugSettingChangeListener iDebugSettingChangeListener) {
        return listeners.remove(iDebugSettingChangeListener);
    }

    public static interface IDebugSettingChangeListener {
        public void update(DebugSettings var1, DebugSettings var2);
    }

    public static enum HotCodeReplace {
        MANUAL,
        AUTO,
        NEVER;

    }
}

