/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.EvaluatableBreakpoint;
import com.microsoft.java.debug.core.EventHub;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.IEventHub;
import com.microsoft.java.debug.core.IWatchpoint;
import com.microsoft.java.debug.core.Watchpoint;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DebugSession
implements IDebugSession {
    private VirtualMachine vm;
    private EventHub eventHub;

    public DebugSession(VirtualMachine virtualMachine, Logger logger) {
        this.vm = virtualMachine;
        this.eventHub = new EventHub(logger);
    }

    @Override
    public void start() {
        ThreadStartRequest threadStartRequest = this.vm.eventRequestManager().createThreadStartRequest();
        threadStartRequest.setSuspendPolicy(0);
        threadStartRequest.enable();
        ThreadDeathRequest threadDeathRequest = this.vm.eventRequestManager().createThreadDeathRequest();
        threadDeathRequest.setSuspendPolicy(0);
        threadDeathRequest.enable();
        this.eventHub.start(this.vm);
    }

    @Override
    public void suspend() {
        this.vm.suspend();
    }

    @Override
    public void resume() {
        for (ThreadReference threadReference : DebugUtility.getAllThreadsSafely(this)) {
            while (!threadReference.isCollected() && threadReference.suspendCount() > 1) {
                threadReference.resume();
            }
        }
        this.vm.resume();
    }

    @Override
    public void detach() {
        this.vm.dispose();
    }

    @Override
    public void terminate() {
        if (this.vm.process() == null || this.vm.process().isAlive()) {
            this.vm.exit(0);
        }
    }

    @Override
    public IBreakpoint createBreakpoint(String string, int n, int n2, String string2, String string3) {
        return new EvaluatableBreakpoint(this.vm, this.getEventHub(), string, n, n2, string2, string3);
    }

    @Override
    public IWatchpoint createWatchPoint(String string, String string2, String string3, String string4, int n) {
        return new Watchpoint(this.vm, this.getEventHub(), string, string2, string3, string4, n);
    }

    @Override
    public void setExceptionBreakpoints(boolean bl, boolean bl2) {
        this.setExceptionBreakpoints(bl, bl2, null, null);
    }

    @Override
    public void setExceptionBreakpoints(boolean bl, boolean bl2, String[] stringArray, String[] stringArray2) {
        EventRequestManager eventRequestManager = this.vm.eventRequestManager();
        ArrayList<ExceptionRequest> arrayList = new ArrayList<ExceptionRequest>(eventRequestManager.exceptionRequests());
        eventRequestManager.deleteEventRequests(arrayList);
        if (bl || bl2) {
            this.vm.allThreads();
            ExceptionRequest exceptionRequest = eventRequestManager.createExceptionRequest(null, bl, bl2);
            exceptionRequest.setSuspendPolicy(1);
            if (stringArray != null) {
                for (String string : stringArray) {
                    exceptionRequest.addClassFilter(string);
                }
            }
            if (stringArray2 != null) {
                for (String string : stringArray2) {
                    exceptionRequest.addClassExclusionFilter(string);
                }
            }
            exceptionRequest.enable();
        }
    }

    @Override
    public Process process() {
        return this.vm.process();
    }

    @Override
    public List<ThreadReference> getAllThreads() {
        return this.vm.allThreads();
    }

    @Override
    public IEventHub getEventHub() {
        return this.eventHub;
    }

    @Override
    public VirtualMachine getVM() {
        return this.vm;
    }
}

