/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import monix.execution.Ack;
import monix.execution.Ack$Continue$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.execution.internal.Platform$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc!\u0002\u0006\f\u0005=\u0019\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0011-\u0002!\u0011!Q\u0001\n1BQa\f\u0001\u0005\u0002ABa!\u000e\u0001!\u0002\u00131\u0004\"\u0002 \u0001\t\u0003y\u0004\"\u0002'\u0001\t\u0013i\u0005\"\u0002:\u0001\t\u0013\u0019\bbBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u0003{\u0001A\u0011BA \u0005UIe\u000e];u'R\u0014X-Y7PEN,'O^1cY\u0016T!\u0001D\u0007\u0002\u0011\t,\u0018\u000e\u001c3feNT!AD\b\u0002\u0011%tG/\u001a:oC2T!\u0001E\t\u0002\u0011I,\u0017m\u0019;jm\u0016T\u0011AE\u0001\u0006[>t\u0017\u000e_\n\u0003\u0001Q\u00012!\u0006\f\u0019\u001b\u0005y\u0011BA\f\u0010\u0005)y%m]3sm\u0006\u0014G.\u001a\t\u00043qqR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ey\u0012B\u0001\u0011\u001b\u0005\u0011\u0011\u0015\u0010^3\u0002\u0005%t7\u0001\u0001\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\n!![8\u000b\u0003!\nAA[1wC&\u0011!&\n\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0005dQVt7nU5{KB\u0011\u0011$L\u0005\u0003]i\u00111!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0019\u0011g\r\u001b\u0011\u0005I\u0002Q\"A\u0006\t\u000b\u0005\u001a\u0001\u0019A\u0012\t\u000b-\u001a\u0001\u0019\u0001\u0017\u0002\u001b]\f7oU;cg\u000e\u0014\u0018NY3e!\t9D(D\u00019\u0015\tI$(\u0001\u0004bi>l\u0017n\u0019\u0006\u0003wE\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005uB$!D!u_6L7MQ8pY\u0016\fg.A\tv]N\fg-Z*vEN\u001c'/\u001b2f\r:$\"\u0001\u0011#\u0011\u0005\u0005\u0013U\"\u0001\u001e\n\u0005\rS$AC\"b]\u000e,G.\u00192mK\")Q)\u0002a\u0001\r\u0006\u0019q.\u001e;\u0011\u0007\u001dS\u0005$D\u0001I\u0015\tIu\"A\u0005pEN,'O^3sg&\u00111\n\u0013\u0002\u000b'V\u00147o\u0019:jE\u0016\u0014\u0018A\u0003:fg\u000eDW\rZ;mKR1aj\u00162eK6$\"a\u0014*\u0011\u0005e\u0001\u0016BA)\u001b\u0005\u0011)f.\u001b;\t\u000bM3\u00019\u0001+\u0002\u0003M\u0004\"!Q+\n\u0005YS$!C*dQ\u0016$W\u000f\\3s\u0011\u0015Af\u00011\u0001Z\u0003\r\t7m\u001b\t\u00045v{V\"A.\u000b\u0005qS\u0012AC2p]\u000e,(O]3oi&\u0011al\u0017\u0002\u0007\rV$XO]3\u0011\u0005\u0005\u0003\u0017BA1;\u0005\r\t5m\u001b\u0005\u0006G\u001a\u0001\r\u0001G\u0001\u0002E\")QI\u0002a\u0001\r\")aM\u0002a\u0001O\u0006\t1\r\u0005\u0002iW6\t\u0011N\u0003\u0002ku\u0005Y1-\u00198dK2\f'\r\\3t\u0013\ta\u0017NA\tC_>dW-\u00198DC:\u001cW\r\\1cY\u0016DQA\u001c\u0004A\u0002=\f!!Z7\u0011\u0005\u0005\u0003\u0018BA9;\u00059)\u00050Z2vi&|g.T8eK2\f\u0001BZ1ti2{w\u000e\u001d\u000b\u0007iZD\u0018P_>\u0015\u0005=+\b\"B*\b\u0001\b!\u0006\"B<\b\u0001\u0004A\u0012A\u00022vM\u001a,'\u000fC\u0003F\u000f\u0001\u0007a\tC\u0003g\u000f\u0001\u0007q\rC\u0003o\u000f\u0001\u0007q\u000eC\u0003}\u000f\u0001\u0007A&A\u0005ts:\u001c\u0017J\u001c3fq\"\u0012qA \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019AG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0004\u0003\u0003\u0011q\u0001^1jYJ,7-A\u0005tK:$WI\u001d:peR1\u0011QBA\f\u0003C!2aTA\b\u0011\u0019\u0019\u0006\u0002q\u0001\u0002\u0012A\u0019\u0011)a\u0005\n\u0007\u0005U!HA\rV]\u000e\fWo\u001a5u\u000bb\u001cW\r\u001d;j_:\u0014V\r]8si\u0016\u0014\bBB#\t\u0001\u0004\tI\u0002\u0005\u0003H\u0015\u0006m\u0001cA\r\u0002\u001e%\u0019\u0011q\u0004\u000e\u0003\u000f9{G\u000f[5oO\"9\u00111\u0005\u0005A\u0002\u0005\u0015\u0012!A3\u0011\t\u0005\u001d\u0012q\u0007\b\u0005\u0003S\t\u0019D\u0004\u0003\u0002,\u0005ERBAA\u0017\u0015\r\tyCI\u0001\u0007yI|w\u000e\u001e \n\u0003mI1!!\u000e\u001b\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000f\u0002<\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003kQ\u0012!\u0004:fa>\u0014HOR1jYV\u0014X\r\u0006\u0003\u0002B\u0005\u0015CcA(\u0002D!11+\u0003a\u0002\u0003#Aq!a\t\n\u0001\u0004\t)\u0003")
public final class InputStreamObservable
extends Observable<byte[]> {
    private final InputStream in;
    private final int chunkSize;
    private final AtomicBoolean wasSubscribed;

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<byte[]> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.compareAndSet(false, true)) {
            void var3_3;
            byte[] buffer = new byte[this.chunkSize];
            BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
            ExecutionModel em = out.scheduler().executionModel();
            this.reschedule((Future<Ack>)Ack$Continue$.MODULE$, buffer, out, cancelable2, em, out.scheduler());
            cancelable = var3_3;
        } else {
            out.onError((Throwable)APIContractViolationException$.MODULE$.apply("InputStreamObservable does not support multiple subscribers"));
            cancelable = Cancelable$.MODULE$.empty();
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, byte[] b, Subscriber<byte[]> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            InputStreamObservable.$anonfun$reschedule$1(this, c, b, out, em, s, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)s);
    }

    private void fastLoop(byte[] buffer, Subscriber<byte[]> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block12: {
            BoxedUnit boxedUnit;
            boolean streamErrors;
            Throwable errorThrown;
            block11: {
                Ack$Continue$ ack;
                while (true) {
                    int nextIndex;
                    int n;
                    errorThrown = null;
                    ack = Ack$Continue$.MODULE$;
                    streamErrors = true;
                    try {
                        Future<Ack> future;
                        int length = BoxesRunTime.unboxToInt((Object)package$.MODULE$.blocking((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.in.read(buffer)));
                        streamErrors = false;
                        if (length >= 0) {
                            byte[] next = Arrays.copyOf(buffer, length);
                            future = out.onNext(next);
                        } else {
                            out.onComplete();
                            future = Ack.Stop$.MODULE$;
                        }
                        ack = future;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            errorThrown = throwable2;
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                    if (errorThrown != null) break block11;
                    Ack$Continue$ ack$Continue$ = ack;
                    Ack$Continue$ ack$Continue$2 = Ack$Continue$.MODULE$;
                    if (!(ack$Continue$ != null ? !ack$Continue$.equals(ack$Continue$2) : ack$Continue$2 != null)) {
                        n = em.nextFrameIndex(syncIndex);
                    } else {
                        Ack$Continue$ ack$Continue$3 = ack;
                        Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                        n = !(ack$Continue$3 != null ? !ack$Continue$3.equals(stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                    }
                    if (nextIndex < 0 || c.isCanceled()) {
                        boxedUnit = BoxedUnit.UNIT;
                        break block12;
                    }
                    if (nextIndex <= 0) break;
                    syncIndex = nextIndex;
                }
                this.reschedule((Future<Ack>)ack, buffer, out, c, em, s);
                boxedUnit = BoxedUnit.UNIT;
                break block12;
            }
            if (streamErrors) {
                this.sendError(out, errorThrown, (UncaughtExceptionReporter)s);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.reportFailure(errorThrown, (UncaughtExceptionReporter)s);
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void sendError(Subscriber<Nothing$> out, Throwable e, UncaughtExceptionReporter s) {
        try {
            out.onError(e);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e2 = (Throwable)option.get();
                this.reportFailure(Platform$.MODULE$.composeErrors(e, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{e2})), s);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void reportFailure(Throwable e, UncaughtExceptionReporter s) {
        s.reportFailure(e);
        try {
            this.in.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$reschedule$1(InputStreamObservable $this, BooleanCancelable c$1, byte[] b$1, Subscriber out$1, ExecutionModel em$1, Scheduler s$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Ack next;
            Success success = (Success)try_;
            Ack ack = next = (Ack)success.value();
            Ack$Continue$ ack$Continue$ = Ack$Continue$.MODULE$;
            if (!(ack != null ? !ack.equals(ack$Continue$) : ack$Continue$ != null) && !c$1.isCanceled()) {
                $this.fastLoop(b$1, out$1, c$1, em$1, 0, s$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            $this.reportFailure(ex, (UncaughtExceptionReporter)s$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public InputStreamObservable(InputStream in, int chunkSize) {
        this.in = in;
        this.chunkSize = chunkSize;
        this.wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    }
}

