/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import sbt.internal.inc.FilteredReporter;
import sbt.internal.inc.LoggedReporter;
import sbt.internal.inc.ManagedFilteredReporter;
import sbt.internal.inc.ManagedLoggedReporter;
import sbt.internal.inc.ReporterManager;
import sbt.internal.util.Appender;
import sbt.internal.util.MainAppender$;
import sbt.internal.util.ManagedLogger;
import sbt.internal.util.Terminal$;
import sbt.util.Level$;
import sbt.util.LoggerContext$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.sys.package$;
import xsbti.Logger;
import xsbti.Position;
import xsbti.Reporter;
import xsbti.ReporterConfig;

public final class ReporterManager$ {
    public static ReporterManager$ MODULE$;
    private final AtomicInteger idGenerator;
    private final String DefaultName;
    private final boolean UseColor;
    private final Function<Position, Position> NoPositionMapper;

    static {
        new ReporterManager$();
    }

    private AtomicInteger idGenerator() {
        return this.idGenerator;
    }

    private String DefaultName() {
        return this.DefaultName;
    }

    private String generateZincReporterId(String name) {
        return new StringBuilder(1).append(name).append("-").append(this.idGenerator().incrementAndGet()).toString();
    }

    private Enumeration.Value fromJavaLogLevel(Level level) {
        Level level2 = level;
        Level level3 = Level.INFO;
        Level level4 = level2;
        if (!(level3 != null ? !((Object)level3).equals(level4) : level4 != null)) {
            return Level$.MODULE$.Info();
        }
        Level level5 = Level.WARNING;
        Level level6 = level2;
        if (!(level5 != null ? !((Object)level5).equals(level6) : level6 != null)) {
            return Level$.MODULE$.Warn();
        }
        Level level7 = Level.SEVERE;
        Level level8 = level2;
        if (!(level7 != null ? !((Object)level7).equals(level8) : level8 != null)) {
            return Level$.MODULE$.Error();
        }
        Level level9 = Level.OFF;
        Level level10 = level2;
        if (!(level9 != null ? !((Object)level9).equals(level10) : level10 != null)) {
            throw package$.MODULE$.error("Level.OFF is not supported. Change the logging level.");
        }
        return Level$.MODULE$.Debug();
    }

    private boolean UseColor() {
        return this.UseColor;
    }

    private Function<Position, Position> NoPositionMapper() {
        return this.NoPositionMapper;
    }

    private <T, R> ReporterManager.EnrichedJava<T, R> EnrichedJava(Function<T, R> f) {
        return new ReporterManager.EnrichedJava<T, R>(f);
    }

    public ReporterConfig getDefaultReporterConfig() {
        return ReporterConfig.of(this.DefaultName(), 100, this.UseColor(), (Function[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Function.class)), (Function[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Function.class)), Level.INFO, this.NoPositionMapper());
    }

    public Reporter getReporter(Logger logger, ReporterConfig config) {
        int maxErrors = config.maximumErrors();
        Function1<Position, Position> posMapper = this.EnrichedJava(config.positionMapper()).toScala();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.fileFilters())).isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.msgFilters())).isEmpty()) {
            Logger logger2 = logger;
            if (logger2 instanceof ManagedLogger) {
                ManagedLogger managedLogger = (ManagedLogger)logger2;
                return new ManagedLoggedReporter(maxErrors, managedLogger, posMapper);
            }
            return new LoggedReporter(maxErrors, logger, posMapper);
        }
        Function1[] fileFilters = (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.fileFilters())).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.EnrichedJava((Function)x$1).toScala(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        Function1[] msgFilters = (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.msgFilters())).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.EnrichedJava((Function)x$2).toScala(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        Logger logger3 = logger;
        if (logger3 instanceof ManagedLogger) {
            ManagedLogger managedLogger = (ManagedLogger)logger3;
            return new ManagedFilteredReporter(fileFilters, msgFilters, maxErrors, managedLogger, posMapper);
        }
        return new FilteredReporter(fileFilters, msgFilters, maxErrors, logger, posMapper);
    }

    public Reporter getReporter(PrintWriter toOutput, ReporterConfig config) {
        Function1 printWriterToAppender = MainAppender$.MODULE$.defaultBacked(config.useColor());
        Appender appender = (Appender)printWriterToAppender.apply((Object)toOutput);
        String freshName = this.generateZincReporterId(config.loggerName());
        ManagedLogger logger = LoggerContext$.MODULE$.globalContext().logger(freshName, (Option)None$.MODULE$, (Option)None$.MODULE$);
        String loggerName = logger.name();
        LoggerContext$.MODULE$.globalContext().clearAppenders(loggerName);
        Enumeration.Value sbtLogLevel = this.fromJavaLogLevel(config.logLevel());
        LoggerContext$.MODULE$.globalContext().addAppender(loggerName, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appender), (Object)sbtLogLevel));
        return this.getReporter((Logger)logger, config);
    }

    public Reporter getReporter(PrintStream toOutput, ReporterConfig config) {
        OutputStreamWriter utf8Writer = new OutputStreamWriter((OutputStream)toOutput, StandardCharsets.UTF_8);
        PrintWriter printWriter = new PrintWriter(utf8Writer);
        return this.getReporter(printWriter, config);
    }

    private ReporterManager$() {
        MODULE$ = this;
        this.idGenerator = new AtomicInteger();
        this.DefaultName = "zinc-out";
        this.UseColor = Terminal$.MODULE$.isColorEnabled();
        this.NoPositionMapper = Function.identity();
    }
}

