/*
 * Decompiled with CFR 0.152.
 */
package jline.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Map;
import java.util.Properties;
import jline.internal.Log;
import jline.internal.Preconditions;
import jline.internal.Urls;

public class Configuration {
    public static final String JLINE_CONFIGURATION = "jline.configuration";
    public static final String JLINE_RC = ".jline.rc";
    private static volatile Properties properties;

    private static Properties initProperties() {
        Properties properties = new Properties();
        try {
            URL uRL = Configuration.determineUrl();
            try {
                Configuration.loadProperties(uRL, properties);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.debug("Unable to read configuration: ", fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                Log.warn("Unable to read configuration from: ", uRL, iOException);
            }
        }
        catch (SecurityException securityException) {
            Log.info("Security policy denied reading configuration file");
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(URL uRL, Properties properties) throws IOException {
        Log.debug("Loading properties from: ", uRL);
        InputStream inputStream = uRL.openStream();
        try {
            properties.load(new BufferedInputStream(inputStream));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (Log.DEBUG) {
            Log.debug("Loaded properties:");
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Log.debug("  ", entry.getKey(), "=", entry.getValue());
            }
        }
    }

    private static URL determineUrl() {
        String string = System.getProperty(JLINE_CONFIGURATION);
        if (string != null) {
            return Urls.create(string);
        }
        File file = new File(Configuration.getUserHome(), JLINE_RC);
        return Urls.create(file);
    }

    public static void reset() {
        Log.debug("Resetting");
        properties = null;
        Configuration.getProperties();
    }

    public static Properties getProperties() {
        if (properties == null) {
            properties = Configuration.initProperties();
        }
        return properties;
    }

    public static String getString(String string, String string2) {
        Preconditions.checkNotNull(string);
        String string3 = System.getProperty(string);
        if (string3 == null && (string3 = Configuration.getProperties().getProperty(string)) == null) {
            string3 = string2;
        }
        return string3;
    }

    public static String getString(String string) {
        return Configuration.getString(string, null);
    }

    public static boolean getBoolean(String string) {
        return Configuration.getBoolean(string, false);
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = Configuration.getString(string);
        if (string2 == null) {
            return bl;
        }
        return string2.length() == 0 || string2.equalsIgnoreCase("1") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("true");
    }

    public static int getInteger(String string, int n) {
        String string2 = Configuration.getString(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public static long getLong(String string, long l) {
        String string2 = Configuration.getString(string);
        if (string2 == null) {
            return l;
        }
        return Long.parseLong(string2);
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isWindows() {
        return Configuration.getOsName().startsWith("windows");
    }

    public static boolean isHpux() {
        return Configuration.getOsName().startsWith("hp");
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getEncoding() {
        for (String string : new String[]{"LC_ALL", "LC_CTYPE", "LANG"}) {
            String string2 = Configuration.extractEncodingFromCtype(System.getenv(string));
            if (string2 == null) continue;
            try {
                if (!Charset.isSupported(string2)) continue;
                return string2;
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
        return Configuration.getString("input.encoding", Charset.defaultCharset().name());
    }

    static String extractEncodingFromCtype(String string) {
        if (string != null && string.indexOf(46) > 0) {
            String string2 = string.substring(string.indexOf(46) + 1);
            if (string2.indexOf(64) > 0) {
                return string2.substring(0, string2.indexOf(64));
            }
            return string2;
        }
        return null;
    }
}

