/*
 * Decompiled with CFR 0.152.
 */
package jline.console.history;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import jline.console.history.History;
import jline.internal.Preconditions;

public class MemoryHistory
implements History {
    public static final int DEFAULT_MAX_SIZE = 500;
    private final LinkedList<CharSequence> items = new LinkedList();
    private int maxSize = 500;
    private boolean ignoreDuplicates = true;
    private boolean autoTrim = false;
    private int offset = 0;
    private int index = 0;

    public void setMaxSize(int n) {
        this.maxSize = n;
        this.maybeResize();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isIgnoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public void setIgnoreDuplicates(boolean bl) {
        this.ignoreDuplicates = bl;
    }

    public boolean isAutoTrim() {
        return this.autoTrim;
    }

    public void setAutoTrim(boolean bl) {
        this.autoTrim = bl;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public int index() {
        return this.offset + this.index;
    }

    @Override
    public void clear() {
        this.items.clear();
        this.offset = 0;
        this.index = 0;
    }

    @Override
    public CharSequence get(int n) {
        return this.items.get(n - this.offset);
    }

    @Override
    public void set(int n, CharSequence charSequence) {
        this.items.set(n - this.offset, charSequence);
    }

    @Override
    public void add(CharSequence charSequence) {
        Preconditions.checkNotNull(charSequence);
        if (this.isAutoTrim()) {
            charSequence = String.valueOf(charSequence).trim();
        }
        if (this.isIgnoreDuplicates() && !this.items.isEmpty() && charSequence.equals(this.items.getLast())) {
            return;
        }
        this.internalAdd(charSequence);
    }

    @Override
    public CharSequence remove(int n) {
        return this.items.remove(n);
    }

    @Override
    public CharSequence removeFirst() {
        return this.items.removeFirst();
    }

    @Override
    public CharSequence removeLast() {
        return this.items.removeLast();
    }

    protected void internalAdd(CharSequence charSequence) {
        this.items.add(charSequence);
        this.maybeResize();
    }

    @Override
    public void replace(CharSequence charSequence) {
        this.items.removeLast();
        this.add(charSequence);
    }

    private void maybeResize() {
        while (this.size() > this.getMaxSize()) {
            this.items.removeFirst();
            ++this.offset;
        }
        this.index = this.size();
    }

    @Override
    public ListIterator<History.Entry> entries(int n) {
        return new EntriesIterator(n - this.offset);
    }

    @Override
    public ListIterator<History.Entry> entries() {
        return this.entries(this.offset);
    }

    @Override
    public Iterator<History.Entry> iterator() {
        return this.entries();
    }

    @Override
    public boolean moveToLast() {
        int n = this.size() - 1;
        if (n >= 0 && n != this.index) {
            this.index = this.size() - 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveTo(int n) {
        if ((n -= this.offset) >= 0 && n < this.size()) {
            this.index = n;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToFirst() {
        if (this.size() > 0 && this.index != 0) {
            this.index = 0;
            return true;
        }
        return false;
    }

    @Override
    public void moveToEnd() {
        this.index = this.size();
    }

    @Override
    public CharSequence current() {
        if (this.index >= this.size()) {
            return "";
        }
        return this.items.get(this.index);
    }

    @Override
    public boolean previous() {
        if (this.index <= 0) {
            return false;
        }
        --this.index;
        return true;
    }

    @Override
    public boolean next() {
        if (this.index >= this.size()) {
            return false;
        }
        ++this.index;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (History.Entry entry : this) {
            stringBuilder.append(entry.toString() + "\n");
        }
        return stringBuilder.toString();
    }

    private class EntriesIterator
    implements ListIterator<History.Entry> {
        private final ListIterator<CharSequence> source;

        private EntriesIterator(int n) {
            this.source = MemoryHistory.this.items.listIterator(n);
        }

        @Override
        public History.Entry next() {
            if (!this.source.hasNext()) {
                throw new NoSuchElementException();
            }
            return new EntryImpl(MemoryHistory.this.offset + this.source.nextIndex(), this.source.next());
        }

        @Override
        public History.Entry previous() {
            if (!this.source.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return new EntryImpl(MemoryHistory.this.offset + this.source.previousIndex(), this.source.previous());
        }

        @Override
        public int nextIndex() {
            return MemoryHistory.this.offset + this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return MemoryHistory.this.offset + this.source.previousIndex();
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(History.Entry entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(History.Entry entry) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EntryImpl
    implements History.Entry {
        private final int index;
        private final CharSequence value;

        public EntryImpl(int n, CharSequence charSequence) {
            this.index = n;
            this.value = charSequence;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public CharSequence value() {
            return this.value;
        }

        public String toString() {
            return String.format("%d: %s", this.index, this.value);
        }
    }
}

