/*
 * Decompiled with CFR 0.152.
 */
package jline.console.completer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jline.console.completer.Completer;
import jline.internal.Ansi;
import jline.internal.Preconditions;

public class AnsiStringsCompleter
implements Completer {
    private final SortedMap<String, String> strings = new TreeMap<String, String>();

    public AnsiStringsCompleter() {
    }

    public AnsiStringsCompleter(Collection<String> collection) {
        Preconditions.checkNotNull(collection);
        for (String string : collection) {
            this.strings.put(Ansi.stripAnsi(string), string);
        }
    }

    public AnsiStringsCompleter(String ... stringArray) {
        this(Arrays.asList(stringArray));
    }

    public Collection<String> getStrings() {
        return this.strings.values();
    }

    @Override
    public int complete(String string, int n, List<CharSequence> list) {
        Preconditions.checkNotNull(list);
        if (string == null) {
            list.addAll(this.strings.values());
        } else {
            string = Ansi.stripAnsi(string);
            for (Map.Entry<String, String> entry : this.strings.tailMap(string).entrySet()) {
                if (!entry.getKey().startsWith(string)) break;
                list.add(entry.getValue());
            }
        }
        return list.isEmpty() ? -1 : 0;
    }
}

