/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watchservice;

import io.methvin.watchservice.AbstractWatchService;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.Arrays;

public class WatchablePath
implements Watchable {
    private final Path file;
    private final boolean isRecursive;
    private static final WatchEvent.Modifier[] NO_MODIFIERS = new WatchEvent.Modifier[0];

    public WatchablePath(Path path, boolean bl) {
        if (path == null) {
            throw new NullPointerException("file must not be null");
        }
        this.file = path;
        this.isRecursive = bl;
    }

    public Path getFile() {
        return this.file;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        if (watchService == null) {
            throw new NullPointerException();
        }
        if (!(watchService instanceof AbstractWatchService)) {
            throw new ProviderMismatchException();
        }
        return ((AbstractWatchService)watchService).register(this, Arrays.asList(kindArray));
    }

    @Override
    public final WatchKey register(WatchService watchService, WatchEvent.Kind<?> ... kindArray) throws IOException {
        if (!this.file.toFile().exists()) {
            throw new RuntimeException("Directory to watch doesn't exist: " + this.file);
        }
        return this.register(watchService, kindArray, NO_MODIFIERS);
    }

    public String toString() {
        return "Path{file=" + this.file + '}';
    }
}

