/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watchservice;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import io.methvin.watcher.PathUtils;
import io.methvin.watcher.hashing.FileHasher;
import io.methvin.watcher.hashing.HashCode;
import io.methvin.watchservice.AbstractWatchKey;
import io.methvin.watchservice.AbstractWatchService;
import io.methvin.watchservice.MacOSXWatchKey;
import io.methvin.watchservice.WatchablePath;
import io.methvin.watchservice.jna.CFArrayRef;
import io.methvin.watchservice.jna.CFIndex;
import io.methvin.watchservice.jna.CFRunLoopRef;
import io.methvin.watchservice.jna.CFStringRef;
import io.methvin.watchservice.jna.CarbonAPI;
import io.methvin.watchservice.jna.FSEventStreamRef;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MacOSXListeningWatchService
extends AbstractWatchService {
    private final List<CarbonAPI.FSEventStreamCallback> callbackList = new ArrayList<CarbonAPI.FSEventStreamCallback>();
    private final List<CFRunLoopThread> threadList = new ArrayList<CFRunLoopThread>();
    private final Set<Path> pathsWatching = new HashSet<Path>();
    private final double latency;
    private final int queueSize;
    private final FileHasher fileHasher;

    public MacOSXListeningWatchService(Config config) {
        this.latency = config.latency();
        this.queueSize = config.queueSize();
        FileHasher fileHasher = config.fileHasher();
        this.fileHasher = fileHasher == null ? FileHasher.DEFAULT_FILE_HASHER : fileHasher;
    }

    public MacOSXListeningWatchService() {
        this(new Config(){});
    }

    @Override
    public AbstractWatchKey register(WatchablePath watchablePath, Iterable<? extends WatchEvent.Kind<?>> iterable) throws IOException {
        this.checkOpen();
        MacOSXWatchKey macOSXWatchKey = new MacOSXWatchKey(this, iterable, this.queueSize);
        Path path = watchablePath.getFile();
        for (Path object2 : this.pathsWatching) {
            if (!path.startsWith(object2)) continue;
            return macOSXWatchKey;
        }
        Map<Path, HashCode> map = PathUtils.createHashCodeMap(path, this.fileHasher);
        String string = path.toFile().getAbsolutePath();
        Pointer[] pointerArray = new Pointer[]{CFStringRef.toCFString(string).getPointer()};
        CFArrayRef cFArrayRef = CarbonAPI.INSTANCE.CFArrayCreate(null, pointerArray, CFIndex.valueOf(1), null);
        MacOSXListeningCallback macOSXListeningCallback = new MacOSXListeningCallback(macOSXWatchKey, this.fileHasher, map, watchablePath);
        this.callbackList.add(macOSXListeningCallback);
        FSEventStreamRef fSEventStreamRef = CarbonAPI.INSTANCE.FSEventStreamCreate(Pointer.NULL, macOSXListeningCallback, Pointer.NULL, cFArrayRef, -1L, this.latency, 2);
        CFRunLoopThread cFRunLoopThread = new CFRunLoopThread(fSEventStreamRef, path.toFile());
        cFRunLoopThread.setDaemon(true);
        cFRunLoopThread.start();
        this.threadList.add(cFRunLoopThread);
        this.pathsWatching.add(path);
        return macOSXWatchKey;
    }

    @Override
    public void close() {
        super.close();
        for (CFRunLoopThread cFRunLoopThread : this.threadList) {
            CarbonAPI.INSTANCE.CFRunLoopStop(cFRunLoopThread.getRunLoop());
            CarbonAPI.INSTANCE.FSEventStreamStop(cFRunLoopThread.getStreamRef());
        }
        this.threadList.clear();
        this.callbackList.clear();
        this.pathsWatching.clear();
    }

    private static class MacOSXListeningCallback
    implements CarbonAPI.FSEventStreamCallback {
        private final MacOSXWatchKey watchKey;
        private final Map<Path, HashCode> hashCodeMap;
        private final FileHasher fileHasher;
        private final WatchablePath watchable;

        private MacOSXListeningCallback(MacOSXWatchKey macOSXWatchKey, FileHasher fileHasher, Map<Path, HashCode> map, WatchablePath watchablePath) {
            this.watchKey = macOSXWatchKey;
            this.hashCodeMap = map;
            this.fileHasher = fileHasher;
            this.watchable = watchablePath;
        }

        @Override
        public void invoke(FSEventStreamRef fSEventStreamRef, Pointer pointer, NativeLong nativeLong, Pointer pointer2, Pointer pointer3, Pointer pointer4) {
            int n = nativeLong.intValue();
            for (String string : pointer2.getStringArray(0L, n)) {
                Path path = new File(string).toPath();
                HashSet<Path> hashSet = new HashSet<Path>();
                if (this.watchable.isRecursive()) {
                    hashSet.addAll(PathUtils.recursiveListFiles(new File(string).toPath()));
                } else {
                    Iterator<Path> iterator = this.watchable.getFile();
                    if (!path.getParent().startsWith((Path)((Object)iterator))) {
                        hashSet.addAll(PathUtils.nonRecursiveListFiles(new File(string).toPath()));
                    }
                }
                for (Path path2 : this.findCreatedFiles(hashSet)) {
                    if (!this.watchKey.isReportCreateEvents()) continue;
                    this.watchKey.signalEvent(StandardWatchEventKinds.ENTRY_CREATE, path2);
                }
                for (Path path2 : this.findModifiedFiles(hashSet)) {
                    if (!this.watchKey.isReportModifyEvents()) continue;
                    this.watchKey.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, path2);
                }
                for (Path path2 : this.findDeletedFiles(string, hashSet)) {
                    if (!this.watchKey.isReportDeleteEvents()) continue;
                    this.watchKey.signalEvent(StandardWatchEventKinds.ENTRY_DELETE, path2);
                }
            }
        }

        private List<Path> findModifiedFiles(Set<Path> set) {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path : set) {
                HashCode hashCode = this.hashCodeMap.get(path);
                HashCode hashCode2 = PathUtils.hash(this.fileHasher, path);
                if (hashCode == null || hashCode.equals(hashCode2) || hashCode2 == null) continue;
                arrayList.add(path);
                this.hashCodeMap.put(path, hashCode2);
            }
            return arrayList;
        }

        private List<Path> findCreatedFiles(Set<Path> set) {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path : set) {
                HashCode hashCode;
                if (this.hashCodeMap.containsKey(path) || (hashCode = PathUtils.hash(this.fileHasher, path)) == null) continue;
                arrayList.add(path);
                this.hashCodeMap.put(path, hashCode);
            }
            return arrayList;
        }

        private List<Path> findDeletedFiles(String string, Set<Path> set) {
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path : this.hashCodeMap.keySet()) {
                if (!path.toFile().getAbsolutePath().startsWith(string) || set.contains(path)) continue;
                arrayList.add(path);
                this.hashCodeMap.remove(path);
            }
            return arrayList;
        }
    }

    public static class CFRunLoopThread
    extends Thread {
        private final FSEventStreamRef streamRef;
        private CFRunLoopRef runLoop;

        public CFRunLoopThread(FSEventStreamRef fSEventStreamRef, File file) {
            super("WatchService for " + file);
            this.streamRef = fSEventStreamRef;
        }

        @Override
        public void run() {
            this.runLoop = CarbonAPI.INSTANCE.CFRunLoopGetCurrent();
            CFStringRef cFStringRef = CFStringRef.toCFString("kCFRunLoopDefaultMode");
            CarbonAPI.INSTANCE.FSEventStreamScheduleWithRunLoop(this.streamRef, this.runLoop, cFStringRef);
            CarbonAPI.INSTANCE.FSEventStreamStart(this.streamRef);
            CarbonAPI.INSTANCE.CFRunLoopRun();
        }

        public CFRunLoopRef getRunLoop() {
            return this.runLoop;
        }

        public FSEventStreamRef getStreamRef() {
            return this.streamRef;
        }
    }

    public static interface Config {
        public static final double DEFAULT_LATENCY = 0.5;
        public static final int DEFAULT_QUEUE_SIZE = 1024;

        default public double latency() {
            return 0.5;
        }

        default public int queueSize() {
            return 1024;
        }

        default public FileHasher fileHasher() {
            return null;
        }
    }
}

