/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher.hashing;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Formatter;

public class HashCode {
    private final byte[] value;

    public static HashCode fromBytes(byte[] byArray) {
        return new HashCode(Arrays.copyOf(byArray, byArray.length));
    }

    public static HashCode fromLong(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(l);
        return new HashCode(byteBuffer.array());
    }

    public static HashCode empty() {
        return new HashCode(new byte[0]);
    }

    private HashCode(byte[] byArray) {
        this.value = byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HashCode hashCode = (HashCode)object;
        return Arrays.equals(this.value, hashCode.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        Formatter formatter = new Formatter();
        for (byte by : this.value) {
            formatter.format("%02x", by);
        }
        return formatter.toString();
    }
}

