/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import com.microsoft.java.debug.core.protocol.Types;
import java.util.List;

public class Responses {

    public static class InlineValuesResponse
    extends ResponseBody {
        public Types.Variable[] variables;

        public InlineValuesResponse(Types.Variable[] variableArray) {
            this.variables = variableArray;
        }
    }

    public static class RedefineClassesResponse
    extends ResponseBody {
        public String[] changedClasses = new String[0];
        public String errorMessage = null;

        public RedefineClassesResponse(String[] stringArray) {
            this(stringArray, null);
        }

        public RedefineClassesResponse(String[] stringArray, String string) {
            this.changedClasses = stringArray;
            this.errorMessage = string;
        }
    }

    public static class ExceptionInfoResponse
    extends ResponseBody {
        public String exceptionId;
        public String description;
        public Types.ExceptionBreakMode breakMode;
        public Types.ExceptionDetails details;

        public ExceptionInfoResponse(String string, String string2, Types.ExceptionBreakMode exceptionBreakMode) {
            this.exceptionId = string;
            this.description = string2;
            this.breakMode = exceptionBreakMode;
        }

        public ExceptionInfoResponse(String string, String string2, Types.ExceptionBreakMode exceptionBreakMode, Types.ExceptionDetails exceptionDetails) {
            this(string, string2, exceptionBreakMode);
            this.details = exceptionDetails;
        }
    }

    public static class ContinueResponseBody
    extends ResponseBody {
        public boolean allThreadsContinued;

        public ContinueResponseBody() {
            this.allThreadsContinued = true;
        }

        public ContinueResponseBody(boolean bl) {
            this.allThreadsContinued = bl;
        }
    }

    public static class DataBreakpointInfoResponseBody
    extends ResponseBody {
        public String dataId;
        public String description;
        public Types.DataBreakpointAccessType[] accessTypes;
        public boolean canPersist;

        public DataBreakpointInfoResponseBody(String string) {
            this(string, null);
        }

        public DataBreakpointInfoResponseBody(String string, String string2) {
            this(string, string2, null);
        }

        public DataBreakpointInfoResponseBody(String string, String string2, Types.DataBreakpointAccessType[] dataBreakpointAccessTypeArray) {
            this(string, string2, dataBreakpointAccessTypeArray, false);
        }

        public DataBreakpointInfoResponseBody(String string, String string2, Types.DataBreakpointAccessType[] dataBreakpointAccessTypeArray, boolean bl) {
            this.dataId = string;
            this.description = string2;
            this.accessTypes = dataBreakpointAccessTypeArray;
            this.canPersist = bl;
        }
    }

    public static class SetDataBreakpointsResponseBody
    extends SetBreakpointsResponseBody {
        public SetDataBreakpointsResponseBody(List<Types.Breakpoint> list) {
            super(list);
        }
    }

    public static class SetBreakpointsResponseBody
    extends ResponseBody {
        public Types.Breakpoint[] breakpoints;

        public SetBreakpointsResponseBody(List<Types.Breakpoint> list) {
            this.breakpoints = list == null ? new Types.Breakpoint[0] : list.toArray(new Types.Breakpoint[0]);
        }
    }

    public static class CompletionsResponseBody
    extends ResponseBody {
        public Types.CompletionItem[] targets;

        public CompletionsResponseBody(List<Types.CompletionItem> list) {
            this.targets = list == null ? new Types.CompletionItem[0] : list.toArray(new Types.CompletionItem[0]);
        }
    }

    public static class EvaluateResponseBody
    extends ResponseBody {
        public String result;
        public int variablesReference;
        public String type;
        public int indexedVariables;

        public EvaluateResponseBody(String string, int n, String string2, int n2) {
            this.result = string;
            this.variablesReference = n;
            this.type = string2;
            this.indexedVariables = n2;
        }
    }

    public static class ThreadsResponseBody
    extends ResponseBody {
        public Types.Thread[] threads;

        public ThreadsResponseBody(List<Types.Thread> list) {
            this.threads = list == null ? new Types.Thread[0] : list.toArray(new Types.Thread[0]);
        }
    }

    public static class SourceResponseBody
    extends ResponseBody {
        public String content;
        public String mimeType = "text/x-java";

        public SourceResponseBody(String string) {
            this.content = string;
        }

        public SourceResponseBody(String string, String string2) {
            this.content = string;
            this.mimeType = string2;
        }
    }

    public static class SetVariablesResponseBody
    extends ResponseBody {
        public String value;
        public String type;
        public int variablesReference;
        public int indexedVariables;

        public SetVariablesResponseBody(String string, String string2, int n, int n2) {
            this.type = string;
            this.value = string2;
            this.variablesReference = n;
            this.indexedVariables = n2;
        }
    }

    public static class VariablesResponseBody
    extends ResponseBody {
        public Types.Variable[] variables;

        public VariablesResponseBody(List<Types.Variable> list) {
            this.variables = list == null ? new Types.Variable[0] : list.toArray(new Types.Variable[0]);
        }
    }

    public static class ScopesResponseBody
    extends ResponseBody {
        public Types.Scope[] scopes;

        public ScopesResponseBody(List<Types.Scope> list) {
            this.scopes = list == null ? new Types.Scope[0] : list.toArray(new Types.Scope[0]);
        }
    }

    public static class StackTraceResponseBody
    extends ResponseBody {
        public Types.StackFrame[] stackFrames;
        public int totalFrames;

        public StackTraceResponseBody(List<Types.StackFrame> list, int n) {
            this.stackFrames = list == null ? new Types.StackFrame[0] : list.toArray(new Types.StackFrame[0]);
            this.totalFrames = n;
        }
    }

    public static class ErrorResponseBody
    extends ResponseBody {
        public Types.Message error;

        public ErrorResponseBody(Types.Message message) {
            this.error = message;
        }
    }

    public static class RunInTerminalResponseBody
    extends ResponseBody {
        public int processId;

        public RunInTerminalResponseBody(int n) {
            this.processId = n;
        }
    }

    public static class InitializeResponseBody
    extends ResponseBody {
        public Types.Capabilities body;

        public InitializeResponseBody(Types.Capabilities capabilities) {
            this.body = capabilities;
        }
    }

    public static class ResponseBody {
    }
}

