/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.IProtocolServer;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractProtocolServer
implements IProtocolServer {
    protected final Logger logger;
    private static final int BUFFER_SIZE = 4096;
    private static final String TWO_CRLF = "\r\n\r\n";
    private static final Pattern CONTENT_LENGTH_MATCHER = Pattern.compile("Content-Length: (\\d+)");
    private static final Charset PROTOCOL_ENCODING = StandardCharsets.UTF_8;
    protected boolean terminateSession = false;
    private Reader reader;
    private Writer writer;
    private ByteBuffer rawData;
    private int contentLength = -1;
    private AtomicInteger sequenceNumber = new AtomicInteger(1);
    private PublishSubject<Messages.Response> responseSubject = PublishSubject.create();
    private PublishSubject<Messages.Request> requestSubject = PublishSubject.create();

    public AbstractProtocolServer(InputStream inputStream, OutputStream outputStream, Logger logger) {
        this.logger = logger;
        this.reader = new BufferedReader(new InputStreamReader(inputStream, PROTOCOL_ENCODING));
        this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, PROTOCOL_ENCODING)));
        this.contentLength = -1;
        this.rawData = new ByteBuffer();
        this.requestSubject.observeOn(Schedulers.newThread()).subscribe(request -> {
            try {
                this.dispatchRequest((Messages.Request)request);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, String.format("Dispatch debug protocol error: %s", exception.toString()), exception);
            }
        });
    }

    public void run() {
        char[] cArray = new char[4096];
        try {
            int n;
            while (!this.terminateSession && (n = this.reader.read(cArray, 0, 4096)) != -1) {
                this.rawData.append(new String(cArray, 0, n).getBytes(PROTOCOL_ENCODING));
                this.processData();
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, String.format("Read data from io exception: %s", iOException.toString()), iOException);
        }
        this.requestSubject.onComplete();
    }

    public void stop() {
        this.terminateSession = true;
    }

    private void sendMessage(Messages.ProtocolMessage protocolMessage) {
        protocolMessage.seq = this.sequenceNumber.getAndIncrement();
        String string = JsonUtils.toJson(protocolMessage);
        byte[] byArray = string.getBytes(PROTOCOL_ENCODING);
        String string2 = String.format("Content-Length: %d%s", byArray.length, TWO_CRLF);
        byte[] byArray2 = string2.getBytes(PROTOCOL_ENCODING);
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.append(byArray2);
        byteBuffer.append(byArray);
        String string3 = byteBuffer.getString(PROTOCOL_ENCODING);
        try {
            if (protocolMessage instanceof Messages.Request) {
                this.logger.fine("\n[[REQUEST]]\n" + string3);
            } else if (protocolMessage instanceof Messages.Event) {
                this.logger.fine("\n[[EVENT]]\n" + string3);
            } else {
                this.logger.fine("\n[[RESPONSE]]\n" + string3);
            }
            this.writer.write(string3);
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, String.format("Write data to io exception: %s", iOException.toString()), iOException);
        }
    }

    @Override
    public void sendEvent(Events.DebugEvent debugEvent) {
        this.sendMessage(new Messages.Event(debugEvent.type, debugEvent));
    }

    @Override
    public void sendResponse(Messages.Response response) {
        this.sendMessage(response);
    }

    @Override
    public CompletableFuture<Messages.Response> sendRequest(Messages.Request request) {
        return this.sendRequest(request, 0L);
    }

    @Override
    public CompletableFuture<Messages.Response> sendRequest(Messages.Request request, long l) {
        Disposable[] disposableArray;
        final CompletableFuture<Messages.Response> completableFuture = new CompletableFuture<Messages.Response>();
        Timer timer = new Timer();
        disposableArray = new Disposable[]{this.responseSubject.filter(response -> response.request_seq == request.seq).take(1L).observeOn(Schedulers.newThread()).subscribe(response -> {
            try {
                timer.cancel();
                completableFuture.complete((Messages.Response)response);
                if (disposableArray[0] != null) {
                    disposableArray[0].dispose();
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, String.format("Handle response error: %s", exception.toString()), exception);
            }
        })};
        this.sendMessage(request);
        if (l > 0L) {
            try {
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (disposableArray[0] != null) {
                            disposableArray[0].dispose();
                        }
                        completableFuture.completeExceptionally(new TimeoutException("timeout"));
                    }
                }, l);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return completableFuture;
    }

    private void processData() {
        while (true) {
            Object object;
            Object object2;
            if (this.contentLength >= 0 && this.rawData.length() >= this.contentLength) {
                object2 = this.rawData.removeFirst(this.contentLength);
                this.contentLength = -1;
                String string = new String((byte[])object2, PROTOCOL_ENCODING);
                try {
                    object = JsonUtils.fromJson(string, Messages.ProtocolMessage.class);
                    this.logger.fine(String.format("\n[%s]\n%s", ((Messages.ProtocolMessage)object).type, string));
                    if (((Messages.ProtocolMessage)object).type.equals("request")) {
                        Messages.Request request = JsonUtils.fromJson(string, Messages.Request.class);
                        this.requestSubject.onNext((Object)request);
                        continue;
                    }
                    if (!((Messages.ProtocolMessage)object).type.equals("response")) continue;
                    Messages.Response response = JsonUtils.fromJson(string, Messages.Response.class);
                    this.responseSubject.onNext((Object)response);
                }
                catch (Exception exception) {
                    this.logger.log(Level.SEVERE, String.format("Error parsing message: %s", exception.toString()), exception);
                }
                continue;
            }
            object2 = this.rawData.getString(PROTOCOL_ENCODING);
            int n = ((String)object2).indexOf(TWO_CRLF);
            if (n == -1 || !((Matcher)(object = CONTENT_LENGTH_MATCHER.matcher((CharSequence)object2))).find()) break;
            this.contentLength = Integer.parseInt(((Matcher)object).group(1));
            int n2 = ((String)object2).substring(0, n + TWO_CRLF.length()).getBytes(PROTOCOL_ENCODING).length;
            this.rawData.removeFirst(n2);
        }
    }

    protected abstract void dispatchRequest(Messages.Request var1);

    class ByteBuffer {
        private byte[] buffer = new byte[0];

        public int length() {
            return this.buffer.length;
        }

        public String getString(Charset charset) {
            return new String(this.buffer, charset);
        }

        public void append(byte[] byArray) {
            this.append(byArray, byArray.length);
        }

        public void append(byte[] byArray, int n) {
            byte[] byArray2 = new byte[this.buffer.length + n];
            System.arraycopy(this.buffer, 0, byArray2, 0, this.buffer.length);
            System.arraycopy(byArray, 0, byArray2, this.buffer.length, n);
            this.buffer = byArray2;
        }

        public byte[] removeFirst(int n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, 0, byArray, 0, n);
            byte[] byArray2 = new byte[this.buffer.length - n];
            System.arraycopy(this.buffer, n, byArray2, 0, this.buffer.length - n);
            this.buffer = byArray2;
            return byArray;
        }
    }
}

