/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Variable {
    public Value value;
    public String name;
    public Field field;
    public LocalVariable local;
    public int argumentIndex;
    public String evaluateName;
    private boolean isUnboundedType = false;

    public Variable(String string, Value value) {
        this(string, value, string);
    }

    public Variable(String string, Value value, String string2) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Name is required for a java variable.");
        }
        this.name = string;
        this.value = value;
        this.argumentIndex = -1;
        this.evaluateName = string2;
    }

    public Type getDeclaringType() {
        if (this.field != null) {
            return this.field.declaringType();
        }
        return null;
    }

    public void setUnboundedType(boolean bl) {
        this.isUnboundedType = bl;
    }

    public boolean isUnboundedType() {
        if (this.isUnboundedType) {
            return true;
        }
        return this.field != null && Objects.equals(this.field.signature(), "Ljava/lang/Object;");
    }
}

