/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Types;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class InitializeRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.INITIALIZE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Requests.InitializeArguments initializeArguments = (Requests.InitializeArguments)arguments;
        iDebugAdapterContext.setClientLinesStartAt1(initializeArguments.linesStartAt1);
        iDebugAdapterContext.setClientColumnsStartAt1(initializeArguments.columnsStartAt1);
        String string = initializeArguments.pathFormat;
        if (string != null) {
            switch (string) {
                case "uri": {
                    iDebugAdapterContext.setClientPathsAreUri(true);
                    break;
                }
                default: {
                    iDebugAdapterContext.setClientPathsAreUri(false);
                }
            }
        }
        iDebugAdapterContext.setSupportsRunInTerminalRequest(initializeArguments.supportsRunInTerminalRequest);
        Object object = new Types.Capabilities();
        ((Types.Capabilities)object).supportsConfigurationDoneRequest = true;
        ((Types.Capabilities)object).supportsHitConditionalBreakpoints = true;
        ((Types.Capabilities)object).supportsConditionalBreakpoints = true;
        ((Types.Capabilities)object).supportsSetVariable = true;
        ((Types.Capabilities)object).supportTerminateDebuggee = true;
        ((Types.Capabilities)object).supportsCompletionsRequest = true;
        ((Types.Capabilities)object).supportsRestartFrame = true;
        ((Types.Capabilities)object).supportsLogPoints = true;
        ((Types.Capabilities)object).supportsEvaluateForHovers = false;
        Types.ExceptionBreakpointFilter[] exceptionBreakpointFilterArray = new Types.ExceptionBreakpointFilter[]{Types.ExceptionBreakpointFilter.UNCAUGHT_EXCEPTION_FILTER, Types.ExceptionBreakpointFilter.CAUGHT_EXCEPTION_FILTER};
        ((Types.Capabilities)object).exceptionBreakpointFilters = exceptionBreakpointFilterArray;
        ((Types.Capabilities)object).supportsExceptionInfoRequest = true;
        ((Types.Capabilities)object).supportsDataBreakpoints = true;
        ((Types.Capabilities)object).supportsClipboardContext = true;
        response.body = object;
        return CompletableFuture.completedFuture(response);
    }
}

