/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class DataBreakpointInfoRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.DATABREAKPOINTINFO);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        ObjectReference objectReference;
        ReferenceType referenceType;
        Field field;
        Object object;
        Requests.DataBreakpointInfoArguments dataBreakpointInfoArguments = (Requests.DataBreakpointInfoArguments)arguments;
        if (dataBreakpointInfoArguments.variablesReference > 0 && (object = iDebugAdapterContext.getRecyclableIdPool().getObjectById(dataBreakpointInfoArguments.variablesReference)) instanceof VariableProxy && !(((VariableProxy)object).getProxiedVariable() instanceof StackFrameReference) && (field = (referenceType = (objectReference = (ObjectReference)((VariableProxy)object).getProxiedVariable()).referenceType()).fieldByName(dataBreakpointInfoArguments.name)) != null) {
            String string = referenceType.name();
            String string2 = String.format("%s#%s", string, dataBreakpointInfoArguments.name);
            String string3 = String.format("%s.%s : %s", this.getSimpleName(string), dataBreakpointInfoArguments.name, this.getSimpleName(field.typeName()));
            response.body = new Responses.DataBreakpointInfoResponseBody(string2, string3, Types.DataBreakpointAccessType.values(), true);
        }
        return CompletableFuture.completedFuture(response);
    }

    private String getSimpleName(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        String[] stringArray = string.split("\\.");
        return stringArray[stringArray.length - 1];
    }
}

