/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.ICompletionsProvider;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class CompletionsHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.COMPLETIONS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Requests.CompletionsArguments completionsArguments = (Requests.CompletionsArguments)arguments;
        if (completionsArguments.frameId == 0) {
            response.body = new Responses.CompletionsResponseBody(Collections.emptyList());
            return CompletableFuture.completedFuture(response);
        }
        StackFrameReference stackFrameReference = (StackFrameReference)iDebugAdapterContext.getRecyclableIdPool().getObjectById(completionsArguments.frameId);
        if (stackFrameReference == null) {
            throw AdapterUtils.createCompletionException(String.format("Completions: cannot find the stack frame with frameID %s", completionsArguments.frameId), ErrorCode.COMPLETIONS_FAILURE);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                ICompletionsProvider iCompletionsProvider = iDebugAdapterContext.getProvider(ICompletionsProvider.class);
                if (iCompletionsProvider != null) {
                    ThreadReference threadReference = stackFrameReference.getThread();
                    List<Types.CompletionItem> list = iCompletionsProvider.codeComplete(threadReference.frame(stackFrameReference.getDepth()), completionsArguments.text, completionsArguments.line, completionsArguments.column);
                    response.body = new Responses.CompletionsResponseBody(list);
                }
                return response;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                throw AdapterUtils.createCompletionException(String.format("Cannot provide code completions because of %s.", incompatibleThreadStateException.toString()), ErrorCode.COMPLETIONS_FAILURE, incompatibleThreadStateException);
            }
        });
    }
}

