/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.ICompletionsProvider;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.IVirtualMachineManagerProvider;
import com.microsoft.java.debug.core.adapter.handler.VMHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class AttachRequestHandler
implements IDebugRequestHandler {
    private final Logger logger;
    private VMHandler vmHandler = new VMHandler();

    public AttachRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.ATTACH);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Object object;
        Object object2;
        Object object3;
        Requests.AttachArguments attachArguments = (Requests.AttachArguments)arguments;
        iDebugAdapterContext.setAttached(true);
        iDebugAdapterContext.setSourcePaths(attachArguments.sourcePaths);
        iDebugAdapterContext.setDebuggeeEncoding(StandardCharsets.UTF_8);
        iDebugAdapterContext.setStepFilters(attachArguments.stepFilters);
        IVirtualMachineManagerProvider iVirtualMachineManagerProvider = iDebugAdapterContext.getProvider(IVirtualMachineManagerProvider.class);
        this.vmHandler.setVmProvider(iVirtualMachineManagerProvider);
        IDebugSession iDebugSession = null;
        try {
            this.logger.info(String.format("Trying to attach to remote debuggee VM %s:%d .", attachArguments.hostName, attachArguments.port));
            iDebugSession = DebugUtility.attach(iVirtualMachineManagerProvider.getVirtualMachineManager(), attachArguments.hostName, attachArguments.port, attachArguments.timeout, this.logger);
            iDebugAdapterContext.setDebugSession(iDebugSession);
            this.vmHandler.connectVirtualMachine(iDebugSession.getVM());
            this.logger.info("Attaching to debuggee VM succeeded.");
        }
        catch (IllegalConnectorArgumentsException | IOException exception) {
            throw AdapterUtils.createCompletionException(String.format("Failed to attach to remote debuggee VM. Reason: %s", exception.toString()), ErrorCode.ATTACH_FAILURE, exception);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("debuggeeEncoding", iDebugAdapterContext.getDebuggeeEncoding());
        if (attachArguments.projectName != null) {
            hashMap.put("projectName", attachArguments.projectName);
        }
        ISourceLookUpProvider iSourceLookUpProvider = iDebugAdapterContext.getProvider(ISourceLookUpProvider.class);
        iSourceLookUpProvider.initialize(iDebugAdapterContext, hashMap);
        if (iDebugSession != null) {
            object3 = iDebugSession.getVM().version();
            object2 = iSourceLookUpProvider.getJavaRuntimeVersion(attachArguments.projectName);
            if (StringUtils.isNotBlank((CharSequence)object2) && !((String)object2).equals(object3)) {
                object = String.format("[Warn] The debugger and the debuggee are running in different versions of JVMs. You could see wrong source mapping results.\nDebugger JVM version: %s\nDebuggee JVM version: %s", object2, object3);
                this.logger.warning((String)object);
                iDebugAdapterContext.getProtocolServer().sendEvent(Events.OutputEvent.createConsoleOutput((String)object));
            }
        }
        object3 = iDebugAdapterContext.getProvider(IEvaluationProvider.class);
        object3.initialize(iDebugAdapterContext, hashMap);
        object2 = iDebugAdapterContext.getProvider(IHotCodeReplaceProvider.class);
        object2.initialize(iDebugAdapterContext, hashMap);
        object = iDebugAdapterContext.getProvider(ICompletionsProvider.class);
        object.initialize(iDebugAdapterContext, hashMap);
        iDebugAdapterContext.getProtocolServer().sendEvent(new Events.InitializedEvent());
        return CompletableFuture.completedFuture(response);
    }
}

