/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.formatter;

import com.microsoft.java.debug.core.adapter.formatter.IValueFormatter;
import com.microsoft.java.debug.core.adapter.formatter.NumericFormatter;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Map;
import java.util.function.BiFunction;

public class ObjectFormatter
implements IValueFormatter {
    protected final BiFunction<Type, Map<String, Object>, String> typeToStringFunction;

    public ObjectFormatter(BiFunction<Type, Map<String, Object>, String> biFunction) {
        this.typeToStringFunction = biFunction;
    }

    @Override
    public String toString(Object object, Map<String, Object> map) {
        return String.format("%s@%s", this.getPrefix((ObjectReference)object, map), ObjectFormatter.getIdPostfix((ObjectReference)object, map));
    }

    @Override
    public boolean acceptType(Type type, Map<String, Object> map) {
        if (type == null) {
            return false;
        }
        char c = type.signature().charAt(0);
        return c == 'L' || c == '[' || c == 's' || c == 't' || c == 'g' || c == 'l' || c == 'c';
    }

    @Override
    public Value valueOf(String string, Type type, Map<String, Object> map) {
        if (string == null || "null".equals(string)) {
            return null;
        }
        throw new UnsupportedOperationException(String.format("Set value is not supported yet for type %s.", type.name()));
    }

    protected String getPrefix(ObjectReference objectReference, Map<String, Object> map) {
        return this.typeToStringFunction.apply(objectReference.type(), map);
    }

    protected static String getIdPostfix(ObjectReference objectReference, Map<String, Object> map) {
        return NumericFormatter.formatNumber(objectReference.uniqueID(), map);
    }
}

