/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.BreakpointManager;
import com.microsoft.java.debug.core.adapter.ExceptionManager;
import com.microsoft.java.debug.core.adapter.IBreakpointManager;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IExceptionManager;
import com.microsoft.java.debug.core.adapter.IProvider;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import com.microsoft.java.debug.core.adapter.IStackFrameManager;
import com.microsoft.java.debug.core.adapter.IdCollection;
import com.microsoft.java.debug.core.adapter.LRUCache;
import com.microsoft.java.debug.core.adapter.LaunchMode;
import com.microsoft.java.debug.core.adapter.RecyclableObjectPool;
import com.microsoft.java.debug.core.adapter.StackFrameManager;
import com.microsoft.java.debug.core.adapter.StepRequestManager;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.VariableFormatterFactory;
import com.microsoft.java.debug.core.protocol.IProtocolServer;
import com.microsoft.java.debug.core.protocol.Requests;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;

public class DebugAdapterContext
implements IDebugAdapterContext {
    private static final int MAX_CACHE_ITEMS = 10000;
    private final Requests.StepFilters defaultFilters = new Requests.StepFilters();
    private Map<String, String> sourceMappingCache = Collections.synchronizedMap(new LRUCache(10000));
    private IProviderContext providerContext;
    private IProtocolServer server;
    private IDebugSession debugSession;
    private boolean debuggerLinesStartAt1 = true;
    private boolean debuggerPathsAreUri = true;
    private boolean clientLinesStartAt1 = true;
    private boolean clientColumnsStartAt1 = true;
    private boolean clientPathsAreUri = false;
    private boolean supportsRunInTerminalRequest;
    private boolean isAttached = false;
    private String[] sourcePaths;
    private Charset debuggeeEncoding;
    private transient boolean vmTerminated;
    private boolean isVmStopOnEntry = false;
    private LaunchMode launchMode = LaunchMode.DEBUG;
    private Process debuggeeProcess;
    private String mainClass;
    private Requests.StepFilters stepFilters;
    private Path classpathJar = null;
    private Path argsfile = null;
    private IdCollection<String> sourceReferences = new IdCollection();
    private RecyclableObjectPool<Long, Object> recyclableIdPool = new RecyclableObjectPool();
    private IVariableFormatter variableFormatter = VariableFormatterFactory.createVariableFormatter();
    private IStackFrameManager stackFrameManager = new StackFrameManager();
    private IExceptionManager exceptionManager = new ExceptionManager();
    private IBreakpointManager breakpointManager;
    private StepRequestManager stepRequestManager = new StepRequestManager();

    public DebugAdapterContext(IProtocolServer iProtocolServer, IProviderContext iProviderContext, Logger logger) {
        this.providerContext = iProviderContext;
        this.server = iProtocolServer;
        this.breakpointManager = new BreakpointManager(logger);
    }

    @Override
    public IProtocolServer getProtocolServer() {
        return this.server;
    }

    @Override
    public <T extends IProvider> T getProvider(Class<T> clazz) {
        return this.providerContext.getProvider(clazz);
    }

    @Override
    public void setDebugSession(IDebugSession iDebugSession) {
        this.debugSession = iDebugSession;
    }

    @Override
    public IDebugSession getDebugSession() {
        return this.debugSession;
    }

    @Override
    public boolean isDebuggerLinesStartAt1() {
        return this.debuggerLinesStartAt1;
    }

    @Override
    public void setDebuggerLinesStartAt1(boolean bl) {
        this.debuggerLinesStartAt1 = bl;
    }

    @Override
    public boolean isDebuggerPathsAreUri() {
        return this.debuggerPathsAreUri;
    }

    @Override
    public void setDebuggerPathsAreUri(boolean bl) {
        this.debuggerPathsAreUri = bl;
    }

    @Override
    public boolean isClientLinesStartAt1() {
        return this.clientLinesStartAt1;
    }

    @Override
    public void setClientLinesStartAt1(boolean bl) {
        this.clientLinesStartAt1 = bl;
    }

    @Override
    public boolean isClientColumnsStartAt1() {
        return this.clientColumnsStartAt1;
    }

    @Override
    public void setClientColumnsStartAt1(boolean bl) {
        this.clientColumnsStartAt1 = bl;
    }

    @Override
    public boolean isClientPathsAreUri() {
        return this.clientPathsAreUri;
    }

    @Override
    public void setClientPathsAreUri(boolean bl) {
        this.clientPathsAreUri = bl;
    }

    @Override
    public void setSupportsRunInTerminalRequest(boolean bl) {
        this.supportsRunInTerminalRequest = bl;
    }

    @Override
    public boolean supportsRunInTerminalRequest() {
        return this.supportsRunInTerminalRequest;
    }

    @Override
    public boolean isAttached() {
        return this.isAttached;
    }

    @Override
    public void setAttached(boolean bl) {
        this.isAttached = bl;
    }

    @Override
    public String[] getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public void setSourcePaths(String[] stringArray) {
        this.sourcePaths = stringArray;
    }

    @Override
    public String getSourceUri(int n) {
        return this.sourceReferences.get(n);
    }

    @Override
    public int createSourceReference(String string) {
        return this.sourceReferences.create(string);
    }

    @Override
    public RecyclableObjectPool<Long, Object> getRecyclableIdPool() {
        return this.recyclableIdPool;
    }

    @Override
    public void setRecyclableIdPool(RecyclableObjectPool<Long, Object> recyclableObjectPool) {
        this.recyclableIdPool = recyclableObjectPool;
    }

    @Override
    public IVariableFormatter getVariableFormatter() {
        return this.variableFormatter;
    }

    @Override
    public void setVariableFormatter(IVariableFormatter iVariableFormatter) {
        this.variableFormatter = iVariableFormatter;
    }

    @Override
    public Map<String, String> getSourceLookupCache() {
        return this.sourceMappingCache;
    }

    @Override
    public void setDebuggeeEncoding(Charset charset) {
        this.debuggeeEncoding = charset;
    }

    @Override
    public Charset getDebuggeeEncoding() {
        return this.debuggeeEncoding;
    }

    @Override
    public void setVmTerminated() {
        this.vmTerminated = true;
    }

    @Override
    public boolean isVmTerminated() {
        return this.vmTerminated;
    }

    @Override
    public void setVmStopOnEntry(boolean bl) {
        this.isVmStopOnEntry = bl;
    }

    @Override
    public boolean isVmStopOnEntry() {
        return this.isVmStopOnEntry;
    }

    @Override
    public void setMainClass(String string) {
        this.mainClass = string;
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public void setStepFilters(Requests.StepFilters stepFilters) {
        if (stepFilters != null && ArrayUtils.isNotEmpty((Object[])stepFilters.classNameFilters)) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            if (ArrayUtils.isNotEmpty((Object[])stepFilters.skipClasses)) {
                linkedHashSet.addAll(Arrays.asList(stepFilters.skipClasses));
            }
            linkedHashSet.addAll(Arrays.asList(stepFilters.classNameFilters));
            stepFilters.skipClasses = linkedHashSet.toArray(new String[0]);
        }
        this.stepFilters = stepFilters;
    }

    @Override
    public Requests.StepFilters getStepFilters() {
        if (this.stepFilters != null) {
            return this.stepFilters;
        }
        if (DebugSettings.getCurrent().stepFilters != null) {
            return DebugSettings.getCurrent().stepFilters;
        }
        return this.defaultFilters;
    }

    @Override
    public IStackFrameManager getStackFrameManager() {
        return this.stackFrameManager;
    }

    @Override
    public LaunchMode getLaunchMode() {
        return this.launchMode;
    }

    @Override
    public void setLaunchMode(LaunchMode launchMode) {
        this.launchMode = launchMode;
    }

    @Override
    public Process getDebuggeeProcess() {
        return this.debuggeeProcess;
    }

    @Override
    public void setDebuggeeProcess(Process process) {
        this.debuggeeProcess = process;
    }

    @Override
    public void setClasspathJar(Path path) {
        this.classpathJar = path;
    }

    @Override
    public Path getClasspathJar() {
        return this.classpathJar;
    }

    @Override
    public void setArgsfile(Path path) {
        this.argsfile = path;
    }

    @Override
    public Path getArgsfile() {
        return this.argsfile;
    }

    @Override
    public IExceptionManager getExceptionManager() {
        return this.exceptionManager;
    }

    @Override
    public IBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    @Override
    public StepRequestManager getStepRequestManager() {
        return this.stepRequestManager;
    }
}

