/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.microsoft.java.debug.core.IWatchpoint;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.WatchpointRequest;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class Watchpoint
implements IWatchpoint,
IEvaluatableBreakpoint {
    private final VirtualMachine vm;
    private final IEventHub eventHub;
    private final String className;
    private final String fieldName;
    private String accessType = null;
    private String condition = null;
    private int hitCount;
    private HashMap<Object, Object> propertyMap = new HashMap();
    private Object compiledConditionalExpression = null;
    private Map<Long, Object> compiledExpressions = new ConcurrentHashMap<Long, Object>();
    private List<EventRequest> requests = new ArrayList<EventRequest>();
    private List<Disposable> subscriptions = new ArrayList<Disposable>();

    Watchpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, String string2) {
        this(virtualMachine, iEventHub, string, string2, "write");
    }

    Watchpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, String string2, String string3) {
        this(virtualMachine, iEventHub, string, string2, string3, null, 0);
    }

    Watchpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, String string2, String string3, String string4, int n) {
        Objects.requireNonNull(virtualMachine);
        Objects.requireNonNull(iEventHub);
        Objects.requireNonNull(string);
        Objects.requireNonNull(string2);
        this.vm = virtualMachine;
        this.eventHub = iEventHub;
        this.className = string;
        this.fieldName = string2;
        this.accessType = string3;
        this.condition = string4;
        this.hitCount = n;
    }

    @Override
    public List<EventRequest> requests() {
        return this.requests;
    }

    @Override
    public List<Disposable> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public void close() throws Exception {
        try {
            this.vm.eventRequestManager().deleteEventRequests(this.requests());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.subscriptions().forEach(disposable -> disposable.dispose());
        this.requests.clear();
        this.subscriptions.clear();
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public String accessType() {
        return this.accessType;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(String string) {
        this.condition = string;
        this.setCompiledConditionalExpression(null);
        this.compiledExpressions.clear();
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public void setHitCount(int n) {
        this.hitCount = n;
        Observable.fromIterable(this.requests()).filter(eventRequest -> eventRequest instanceof WatchpointRequest).subscribe(eventRequest -> {
            eventRequest.addCountFilter(n);
            eventRequest.enable();
        });
    }

    @Override
    public void putProperty(Object object, Object object2) {
        this.propertyMap.put(object, object2);
    }

    @Override
    public Object getProperty(Object object) {
        return this.propertyMap.get(object);
    }

    @Override
    public CompletableFuture<IWatchpoint> install() {
        Disposable disposable = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ThreadDeathEvent).subscribe(debugEvent -> {
            ThreadReference threadReference = ((ThreadDeathEvent)debugEvent.event).thread();
            this.compiledExpressions.remove(threadReference.uniqueID());
        });
        this.subscriptions.add(disposable);
        ClassPrepareRequest classPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter(this.className);
        classPrepareRequest.enable();
        this.requests.add(classPrepareRequest);
        CompletableFuture<IWatchpoint> completableFuture = new CompletableFuture<IWatchpoint>();
        disposable = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ClassPrepareEvent && classPrepareRequest.equals(debugEvent.event.request())).subscribe(debugEvent -> {
            ClassPrepareEvent classPrepareEvent = (ClassPrepareEvent)debugEvent.event;
            List<WatchpointRequest> list = this.createWatchpointRequests(classPrepareEvent.referenceType());
            this.requests.addAll(list);
            if (!list.isEmpty() && !completableFuture.isDone()) {
                this.putProperty("verified", true);
                completableFuture.complete(this);
            }
        });
        this.subscriptions.add(disposable);
        ArrayList<WatchpointRequest> arrayList = new ArrayList<WatchpointRequest>();
        List<ReferenceType> list = this.vm.classesByName(this.className);
        for (ReferenceType referenceType : list) {
            arrayList.addAll(this.createWatchpointRequests(referenceType));
        }
        this.requests.addAll(arrayList);
        if (!arrayList.isEmpty() && !completableFuture.isDone()) {
            this.putProperty("verified", true);
            completableFuture.complete(this);
        }
        return completableFuture;
    }

    private List<WatchpointRequest> createWatchpointRequests(ReferenceType referenceType) {
        ArrayList<WatchpointRequest> arrayList = new ArrayList<WatchpointRequest>();
        Field field = referenceType.fieldByName(this.fieldName);
        if (field != null) {
            if ("read".equals(this.accessType)) {
                arrayList.add(this.vm.eventRequestManager().createAccessWatchpointRequest(field));
            } else if ("readWrite".equals(this.accessType)) {
                arrayList.add(this.vm.eventRequestManager().createAccessWatchpointRequest(field));
                arrayList.add(this.vm.eventRequestManager().createModificationWatchpointRequest(field));
            } else {
                arrayList.add(this.vm.eventRequestManager().createModificationWatchpointRequest(field));
            }
        }
        arrayList.forEach(watchpointRequest -> {
            watchpointRequest.setSuspendPolicy(1);
            if (this.hitCount > 0) {
                watchpointRequest.addCountFilter(this.hitCount);
            }
            watchpointRequest.enable();
        });
        return arrayList;
    }

    @Override
    public String getLogMessage() {
        return null;
    }

    @Override
    public void setLogMessage(String string) {
        throw new UnsupportedOperationException("Log message feature is unsupported for watchpoint.");
    }

    @Override
    public boolean containsEvaluatableExpression() {
        return this.containsConditionalExpression();
    }

    @Override
    public boolean containsConditionalExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getCondition());
    }

    @Override
    public boolean containsLogpointExpression() {
        return false;
    }

    @Override
    public void setCompiledConditionalExpression(Object object) {
        this.compiledConditionalExpression = object;
    }

    @Override
    public Object getCompiledConditionalExpression() {
        return this.compiledConditionalExpression;
    }

    @Override
    public void setCompiledLogpointExpression(Object object) {
    }

    @Override
    public Object getCompiledLogpointExpression() {
        return null;
    }

    @Override
    public Object getCompiledExpression(long l) {
        return this.compiledExpressions.get(l);
    }

    @Override
    public void setCompiledExpression(long l, Object object) {
        this.compiledExpressions.put(l, object);
    }
}

