/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.Breakpoint;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ThreadDeathEvent;
import io.reactivex.disposables.Disposable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class EvaluatableBreakpoint
extends Breakpoint
implements IEvaluatableBreakpoint {
    private IEventHub eventHub = null;
    private Object compiledConditionalExpression = null;
    private Object compiledLogpointExpression = null;
    private Map<Long, Object> compiledExpressions = new ConcurrentHashMap<Long, Object>();

    EvaluatableBreakpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, int n) {
        this(virtualMachine, iEventHub, string, n, 0, null);
    }

    EvaluatableBreakpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, int n, int n2) {
        this(virtualMachine, iEventHub, string, n, n2, null);
    }

    EvaluatableBreakpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, int n, int n2, String string2) {
        this(virtualMachine, iEventHub, string, n, n2, string2, null);
    }

    EvaluatableBreakpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, int n, int n2, String string2, String string3) {
        super(virtualMachine, iEventHub, string, n, n2, string2, string3);
        this.eventHub = iEventHub;
    }

    @Override
    public boolean containsEvaluatableExpression() {
        return this.containsConditionalExpression() || this.containsLogpointExpression();
    }

    @Override
    public boolean containsConditionalExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getCondition());
    }

    @Override
    public boolean containsLogpointExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getLogMessage());
    }

    @Override
    public void setCompiledConditionalExpression(Object object) {
        this.compiledConditionalExpression = object;
    }

    @Override
    public Object getCompiledConditionalExpression() {
        return this.compiledConditionalExpression;
    }

    @Override
    public void setCompiledLogpointExpression(Object object) {
        this.compiledLogpointExpression = object;
    }

    @Override
    public Object getCompiledLogpointExpression() {
        return this.compiledLogpointExpression;
    }

    @Override
    public void setCondition(String string) {
        super.setCondition(string);
        this.setCompiledConditionalExpression(null);
        this.compiledExpressions.clear();
    }

    @Override
    public void setLogMessage(String string) {
        super.setLogMessage(string);
        this.setCompiledLogpointExpression(null);
        this.compiledExpressions.clear();
    }

    @Override
    public Object getCompiledExpression(long l) {
        return this.compiledExpressions.get(l);
    }

    @Override
    public void setCompiledExpression(long l, Object object) {
        this.compiledExpressions.put(l, object);
    }

    @Override
    public CompletableFuture<IBreakpoint> install() {
        Disposable disposable = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ThreadDeathEvent).subscribe(debugEvent -> {
            ThreadReference threadReference = ((ThreadDeathEvent)debugEvent.event).thread();
            this.compiledExpressions.remove(threadReference.uniqueID());
        });
        super.subscriptions().add(disposable);
        return super.install();
    }
}

