/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Optional;
import sbt.internal.inc.ClassFileManager;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.JarUtils$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.util.Logger;
import sbt.util.Logger$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.sys.package$;
import xsbti.PathBasedFile;
import xsbti.VirtualFile;
import xsbti.compile.AuxiliaryClassFiles;
import xsbti.compile.ClassFileManager;
import xsbti.compile.ClassFileManagerType;
import xsbti.compile.DeleteImmediatelyManagerType;
import xsbti.compile.IncOptions;
import xsbti.compile.Output;
import xsbti.compile.TransactionalManagerType;
import xsbti.compile.WrappedClassFileManager;

public final class ClassFileManager$ {
    public static ClassFileManager$ MODULE$;

    static {
        new ClassFileManager$();
    }

    public ClassFileManager getDefaultClassFileManager(Optional<ClassFileManagerType> classFileManagerType, AuxiliaryClassFiles[] auxiliaryClassFiles) {
        if (classFileManagerType.isPresent()) {
            ClassFileManagerType classFileManagerType2 = classFileManagerType.get();
            if (classFileManagerType2 instanceof DeleteImmediatelyManagerType) {
                return new ClassFileManager.DeleteClassFileManager(auxiliaryClassFiles);
            }
            if (classFileManagerType2 instanceof TransactionalManagerType) {
                TransactionalManagerType transactionalManagerType = (TransactionalManagerType)classFileManagerType2;
                return this.transactional(transactionalManagerType.backupDirectory().toPath(), (AuxiliaryClassFiles[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(AuxiliaryClassFiles.class)), Logger$.MODULE$.xlog2Log(transactionalManagerType.logger()));
            }
            throw new MatchError((Object)classFileManagerType2);
        }
        return new ClassFileManager.DeleteClassFileManager(auxiliaryClassFiles);
    }

    public ClassFileManager getDefaultClassFileManager(Optional<ClassFileManagerType> classFileManagerType, Output output, JarUtils.OutputJarContent outputJarContent, AuxiliaryClassFiles[] auxiliaryClassFiles) {
        if (classFileManagerType.isPresent()) {
            ClassFileManagerType classFileManagerType2 = classFileManagerType.get();
            if (classFileManagerType2 instanceof DeleteImmediatelyManagerType) {
                return this.deleteImmediately(output, outputJarContent, auxiliaryClassFiles);
            }
            if (classFileManagerType2 instanceof TransactionalManagerType) {
                TransactionalManagerType transactionalManagerType = (TransactionalManagerType)classFileManagerType2;
                return this.transactional(output, outputJarContent, transactionalManagerType.backupDirectory().toPath(), auxiliaryClassFiles, Logger$.MODULE$.xlog2Log(transactionalManagerType.logger()));
            }
            throw new MatchError((Object)classFileManagerType2);
        }
        return this.deleteImmediately(output, outputJarContent, auxiliaryClassFiles);
    }

    public ClassFileManager getClassFileManager(IncOptions options, Output output, JarUtils.OutputJarContent outputJarContent) {
        ClassFileManager internal = this.getDefaultClassFileManager(options.classfileManagerType(), output, outputJarContent, options.auxiliaryClassFiles());
        Option external = Option$.MODULE$.apply((Object)options.externalHooks()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> JavaInterfaceUtil$.MODULE$.EnrichOptional(x$4.getExternalClassFileManager()).toOption());
        return WrappedClassFileManager.of((ClassFileManager)internal, JavaInterfaceUtil$.MODULE$.EnrichOption(external).toOptional());
    }

    public Path sbt$internal$inc$ClassFileManager$$toPath(VirtualFile vf) {
        VirtualFile virtualFile = vf;
        if (virtualFile instanceof PathBasedFile) {
            PathBasedFile pathBasedFile = (PathBasedFile)virtualFile;
            return pathBasedFile.toPath();
        }
        throw package$.MODULE$.error(new StringBuilder(18).append(virtualFile.id()).append(" is not path-based").toString());
    }

    public ClassFileManager deleteImmediately(AuxiliaryClassFiles[] auxiliaryClassFiles) {
        return new ClassFileManager.DeleteClassFileManager(auxiliaryClassFiles);
    }

    public ClassFileManager deleteImmediatelyFromJar(Path outputJar, JarUtils.OutputJarContent outputJarContent, AuxiliaryClassFiles[] auxiliaryClassFiles) {
        return new ClassFileManager.DeleteClassFileManagerForJar(outputJar, outputJarContent, auxiliaryClassFiles);
    }

    public ClassFileManager deleteImmediately(Output output, JarUtils.OutputJarContent outputJarContent, AuxiliaryClassFiles[] auxiliaryClassFiles) {
        Option outputJar = JarUtils$.MODULE$.getOutputJar(output);
        return (ClassFileManager)outputJar.fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.deleteImmediately(auxiliaryClassFiles), (Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.deleteImmediatelyFromJar((Path)x$6, outputJarContent, auxiliaryClassFiles));
    }

    public ClassFileManager transactional(Path tempDir0, AuxiliaryClassFiles[] auxiliaryClassFiles, Logger logger) {
        return new ClassFileManager.TransactionalClassFileManager(tempDir0, auxiliaryClassFiles, logger);
    }

    public ClassFileManager transactionalForJar(Path outputJar, JarUtils.OutputJarContent outputJarContent, AuxiliaryClassFiles[] auxiliaryClassFiles) {
        return new ClassFileManager.TransactionalClassFileManagerForJar(outputJar, outputJarContent, (Vector<AuxiliaryClassFiles>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])auxiliaryClassFiles)).toVector());
    }

    public ClassFileManager transactional(Output output, JarUtils.OutputJarContent outputJarContent, Path tempDir, AuxiliaryClassFiles[] auxiliaryClassFiles, Logger logger) {
        Option outputJar = JarUtils$.MODULE$.getOutputJar(output);
        return (ClassFileManager)outputJar.fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.transactional(tempDir, auxiliaryClassFiles, logger), (Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.transactionalForJar((Path)x$7, outputJarContent, auxiliaryClassFiles));
    }

    private ClassFileManager$() {
        MODULE$ = this;
    }
}

