/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.LockableMap;
import com.swoval.files.RegisterableWatchService;
import com.swoval.files.apple.ClosedFileEventMonitorException;
import com.swoval.files.apple.FileEvent;
import com.swoval.files.apple.FileEventMonitor;
import com.swoval.files.apple.FileEventMonitors;
import com.swoval.files.apple.Flags;
import com.swoval.functional.Consumer;
import com.swoval.logging.Logger;
import com.swoval.logging.Loggers;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class MacOSXWatchService
implements RegisterableWatchService {
    private final int watchLatency;
    private final TimeUnit watchTimeUnit;
    private final int queueSize;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final WatchKeys registered = new WatchKeys();
    private final LinkedBlockingQueue<MacOSXWatchKey> readyKeys = new LinkedBlockingQueue();
    private final Logger logger;
    private final Consumer<String> dropEvent = new Consumer<String>(){

        @Override
        public void accept(String string) {
            Path path = Paths.get(string, new String[0]);
            WatchKey watchKey = (WatchKey)MacOSXWatchService.this.registered.get(path);
            if (watchKey != null) {
                watchKey.handle = FileEventMonitors.Handles.INVALID;
            }
        }
    };
    private final Consumer<FileEvent> onFileEvent = new Consumer<FileEvent>(){

        @Override
        public void accept(FileEvent fileEvent) {
            WatchKey watchKey;
            Path path = Paths.get(fileEvent.fileName, new String[0]);
            if (Loggers.shouldLog(MacOSXWatchService.this.logger, Loggers.Level.DEBUG)) {
                MacOSXWatchService.this.logger.debug(this + " received event for path " + fileEvent.fileName);
            }
            WatchKey watchKey2 = (watchKey = (WatchKey)MacOSXWatchService.this.registered.get(path)) == null ? (WatchKey)MacOSXWatchService.this.registered.get(path.getParent()) : watchKey;
            boolean bl = Files.exists(path, LinkOption.NOFOLLOW_LINKS);
            if (watchKey2 != null) {
                if (fileEvent.mustScanSubDirs()) {
                    for (MacOSXWatchKey macOSXWatchKey : watchKey2.keys()) {
                        macOSXWatchKey.addOverflow();
                    }
                } else {
                    for (MacOSXWatchKey macOSXWatchKey : watchKey2.keys()) {
                        if (bl && macOSXWatchKey.reportModifyEvents()) {
                            macOSXWatchKey.createEvent(StandardWatchEventKinds.ENTRY_MODIFY, path);
                            continue;
                        }
                        if (bl || !macOSXWatchKey.reportDeleteEvents()) continue;
                        macOSXWatchKey.createEvent(StandardWatchEventKinds.ENTRY_DELETE, path);
                    }
                }
            } else if (Loggers.shouldLog(MacOSXWatchService.this.logger, Loggers.Level.DEBUG)) {
                MacOSXWatchService.this.logger.debug(this + " dropping event for unregistered path " + path);
            }
        }
    };
    private FileEventMonitor fileEventMonitor;

    public MacOSXWatchService(int n, TimeUnit timeUnit, int n2) throws InterruptedException {
        this(n, timeUnit, n2, Loggers.getLogger());
    }

    public MacOSXWatchService(int n, TimeUnit timeUnit, int n2, Logger logger) throws InterruptedException {
        this.watchLatency = n;
        this.queueSize = n2;
        this.watchTimeUnit = timeUnit;
        this.fileEventMonitor = FileEventMonitors.get(this.onFileEvent, this.dropEvent);
        this.logger = logger;
    }

    public MacOSXWatchService() throws InterruptedException {
        this(10, TimeUnit.MILLISECONDS, 1024);
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            for (WatchKey watchKey : new ArrayList(this.registered.values())) {
                if (watchKey.handle != FileEventMonitors.Handles.INVALID) {
                    try {
                        this.fileEventMonitor.stopStream(watchKey.handle);
                    }
                    catch (ClosedFileEventMonitorException closedFileEventMonitorException) {
                        closedFileEventMonitorException.printStackTrace(System.err);
                    }
                }
                watchKey.close();
            }
            this.registered.clear();
            this.fileEventMonitor.close();
        }
    }

    @Override
    public java.nio.file.WatchKey poll() {
        if (this.isOpen()) {
            return this.readyKeys.poll();
        }
        throw new ClosedWatchServiceException();
    }

    @Override
    public java.nio.file.WatchKey poll(long l, TimeUnit timeUnit) throws InterruptedException {
        if (this.isOpen()) {
            return this.readyKeys.poll(l, timeUnit);
        }
        throw new ClosedWatchServiceException();
    }

    @Override
    public java.nio.file.WatchKey take() throws InterruptedException {
        if (this.isOpen()) {
            return this.readyKeys.take();
        }
        throw new ClosedWatchServiceException();
    }

    private boolean isOpen() {
        return this.open.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.nio.file.WatchKey register(Path path, WatchEvent.Kind<?> ... kindArray) throws IOException {
        if (this.isOpen() && this.registered.lock()) {
            try {
                MacOSXWatchKey macOSXWatchKey;
                Object object;
                Path path2 = path.toRealPath(new LinkOption[0]);
                if (!Files.isDirectory(path2, new LinkOption[0])) {
                    throw new NotDirectoryException(path2.toString());
                }
                WatchKey watchKey = (WatchKey)this.registered.get(path2);
                if (watchKey == null) {
                    object = new Flags.Create().setNoDefer().setFileEvents();
                    FileEventMonitors.Handle handle = null;
                    Iterator iterator = this.registered.keys().iterator();
                    while (iterator.hasNext() && handle != FileEventMonitors.Handles.INVALID) {
                        if (!path2.startsWith((Path)iterator.next())) continue;
                        handle = FileEventMonitors.Handles.INVALID;
                    }
                    if (handle != FileEventMonitors.Handles.INVALID) {
                        try {
                            handle = this.fileEventMonitor.createStream(path2, this.watchLatency, this.watchTimeUnit, (Flags.Create)object);
                        }
                        catch (ClosedFileEventMonitorException closedFileEventMonitorException) {
                            this.close();
                            throw closedFileEventMonitorException;
                        }
                    }
                    if (this.registered.put(path2, new WatchKey(handle, macOSXWatchKey = new MacOSXWatchKey(path2, this.queueSize, handle, kindArray))) != null) {
                        macOSXWatchKey.cancel();
                        throw new ClosedWatchServiceException();
                    }
                } else {
                    macOSXWatchKey = new MacOSXWatchKey(path2, this.queueSize, FileEventMonitors.Handles.INVALID, kindArray);
                    watchKey.add(macOSXWatchKey);
                }
                if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                    this.logger.debug(this + " registered path " + path);
                }
                object = macOSXWatchKey;
                return object;
            }
            finally {
                this.registered.unlock();
            }
        }
        throw new ClosedWatchServiceException();
    }

    private class WatchKey
    implements AutoCloseable {
        private FileEventMonitors.Handle handle;
        private final Set<MacOSXWatchKey> _keys = Collections.synchronizedSet(new HashSet());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(MacOSXWatchKey macOSXWatchKey) {
            Set<MacOSXWatchKey> set = this._keys;
            synchronized (set) {
                this._keys.add(macOSXWatchKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<MacOSXWatchKey> keys() {
            Set<MacOSXWatchKey> set = this._keys;
            synchronized (set) {
                return new ArrayList<MacOSXWatchKey>(this._keys);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WatchKey(FileEventMonitors.Handle handle, MacOSXWatchKey macOSXWatchKey) {
            this.handle = handle;
            Set<MacOSXWatchKey> set = this._keys;
            synchronized (set) {
                this._keys.add(macOSXWatchKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Set<MacOSXWatchKey> set = this._keys;
            synchronized (set) {
                Iterator<MacOSXWatchKey> iterator = new ArrayList<MacOSXWatchKey>(this._keys).iterator();
                while (iterator.hasNext()) {
                    iterator.next().cancel();
                }
                this._keys.clear();
            }
        }
    }

    class MacOSXWatchKey
    implements java.nio.file.WatchKey {
        private final ArrayBlockingQueue<WatchEvent<?>> events;
        private final AtomicInteger overflow = new AtomicInteger(0);
        private final AtomicBoolean valid = new AtomicBoolean(true);
        private FileEventMonitors.Handle handle;
        private final boolean reportCreateEvents;
        private final boolean reportModifyEvents;
        private final boolean reportDeleteEvents;
        private final Path watchable;

        public FileEventMonitors.Handle getHandle() {
            return this.handle;
        }

        public void setHandle(FileEventMonitors.Handle handle) {
            this.handle = handle;
        }

        public boolean reportCreateEvents() {
            return this.reportCreateEvents;
        }

        boolean reportModifyEvents() {
            return this.reportModifyEvents;
        }

        boolean reportDeleteEvents() {
            return this.reportDeleteEvents;
        }

        MacOSXWatchKey(Path path, int n, FileEventMonitors.Handle handle, WatchEvent.Kind<?> ... kindArray) {
            this.events = new ArrayBlockingQueue(n);
            this.handle = handle;
            this.watchable = path;
            HashSet hashSet = new HashSet();
            for (int i = 0; i < kindArray.length; ++i) {
                hashSet.add(kindArray[i]);
            }
            this.reportCreateEvents = hashSet.contains(StandardWatchEventKinds.ENTRY_CREATE);
            this.reportModifyEvents = hashSet.contains(StandardWatchEventKinds.ENTRY_MODIFY);
            this.reportDeleteEvents = hashSet.contains(StandardWatchEventKinds.ENTRY_DELETE);
        }

        @Override
        public void cancel() {
            this.valid.set(false);
        }

        @Override
        public Watchable watchable() {
            return this.watchable;
        }

        @Override
        public boolean isValid() {
            return this.valid.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<WatchEvent<?>> pollEvents() {
            MacOSXWatchKey macOSXWatchKey = this;
            synchronized (macOSXWatchKey) {
                int n = this.overflow.getAndSet(0);
                ArrayList<Event<Path>> arrayList = new ArrayList<Event<Path>>(this.events.size() + n > 0 ? 1 : 0);
                this.events.drainTo(arrayList);
                if (n != 0) {
                    arrayList.add(new Event<Path>(StandardWatchEventKinds.OVERFLOW, n, this.watchable));
                }
                return Collections.unmodifiableList(arrayList);
            }
        }

        @Override
        public boolean reset() {
            return true;
        }

        public String toString() {
            return "MacOSXWatchKey(" + this.watchable + ")";
        }

        void addOverflow() {
            this.events.add(new Event<Object>(StandardWatchEventKinds.OVERFLOW, 1, null));
            this.overflow.incrementAndGet();
            if (!MacOSXWatchService.this.readyKeys.contains(this)) {
                MacOSXWatchService.this.readyKeys.offer(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addEvent(Event<Path> event) {
            MacOSXWatchKey macOSXWatchKey = this;
            synchronized (macOSXWatchKey) {
                if (!this.events.offer(event)) {
                    this.overflow.incrementAndGet();
                } else if (!MacOSXWatchService.this.readyKeys.contains(this)) {
                    MacOSXWatchService.this.readyKeys.add(this);
                }
            }
        }

        void createEvent(WatchEvent.Kind<Path> kind, Path path) {
            if (Loggers.shouldLog(MacOSXWatchService.this.logger, Loggers.Level.DEBUG)) {
                MacOSXWatchService.this.logger.debug(this + " creating event for " + path + " with kind " + kind);
            }
            Event<Path> event = new Event<Path>(kind, 1, this.watchable.relativize(path));
            this.addEvent(event);
        }
    }

    private static class Event<T>
    implements WatchEvent<T> {
        private final WatchEvent.Kind<T> _kind;
        private final int _count;
        private final T _context;

        Event(WatchEvent.Kind<T> kind, int n, T t) {
            this._kind = kind;
            this._count = n;
            this._context = t;
        }

        @Override
        public WatchEvent.Kind<T> kind() {
            return this._kind;
        }

        @Override
        public int count() {
            return this._count;
        }

        @Override
        public T context() {
            return this._context;
        }

        public String toString() {
            return "Event(" + this._context + ", " + this._kind + ")";
        }
    }

    private static class WatchKeys
    extends LockableMap<Path, WatchKey> {
        private WatchKeys() {
        }
    }
}

