/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes;

import coursierapi.shaded.coursier.util.shaded.org.jsoup.helper.DataUtil;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Element;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Entities;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.parser.Parser;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.parser.Tag;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.select.Evaluator;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.annotation.Nullable;

public class Document
extends Element {
    private OutputSettings outputSettings = new OutputSettings();
    private Parser parser;
    private QuirksMode quirksMode = QuirksMode.noQuirks;
    private final String location;
    private boolean updateMetaCharset = false;
    private static final Evaluator titleEval = new Evaluator.Tag("title");

    public Document(String baseUri) {
        super(Tag.valueOf("#root", ParseSettings.htmlDefault), baseUri);
        this.location = baseUri;
        this.parser = Parser.htmlParser();
    }

    @Override
    public String outerHtml() {
        return super.html();
    }

    @Override
    public String nodeName() {
        return "#document";
    }

    @Override
    public Document clone() {
        Document clone = (Document)super.clone();
        clone.outputSettings = this.outputSettings.clone();
        return clone;
    }

    public OutputSettings outputSettings() {
        return this.outputSettings;
    }

    public QuirksMode quirksMode() {
        return this.quirksMode;
    }

    public Document quirksMode(QuirksMode quirksMode) {
        this.quirksMode = quirksMode;
        return this;
    }

    public Parser parser() {
        return this.parser;
    }

    public Document parser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public static class OutputSettings
    implements Cloneable {
        private Entities.EscapeMode escapeMode = Entities.EscapeMode.base;
        private Charset charset = DataUtil.UTF_8;
        private final ThreadLocal<CharsetEncoder> encoderThreadLocal = new ThreadLocal();
        @Nullable
        Entities.CoreCharset coreCharset;
        private boolean prettyPrint = true;
        private boolean outline = false;
        private int indentAmount = 1;
        private Syntax syntax = Syntax.html;

        public Entities.EscapeMode escapeMode() {
            return this.escapeMode;
        }

        public OutputSettings charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public OutputSettings charset(String charset) {
            this.charset(Charset.forName(charset));
            return this;
        }

        CharsetEncoder prepareEncoder() {
            CharsetEncoder encoder = this.charset.newEncoder();
            this.encoderThreadLocal.set(encoder);
            this.coreCharset = Entities.CoreCharset.byName(encoder.charset().name());
            return encoder;
        }

        CharsetEncoder encoder() {
            CharsetEncoder encoder = this.encoderThreadLocal.get();
            return encoder != null ? encoder : this.prepareEncoder();
        }

        public Syntax syntax() {
            return this.syntax;
        }

        public boolean prettyPrint() {
            return this.prettyPrint;
        }

        public boolean outline() {
            return this.outline;
        }

        public int indentAmount() {
            return this.indentAmount;
        }

        public OutputSettings clone() {
            OutputSettings clone;
            try {
                clone = (OutputSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            clone.charset(this.charset.name());
            clone.escapeMode = Entities.EscapeMode.valueOf(this.escapeMode.name());
            return clone;
        }

        public static final class Syntax
        extends Enum<Syntax> {
            public static final /* enum */ Syntax html = new Syntax();
            public static final /* enum */ Syntax xml = new Syntax();
            private static final /* synthetic */ Syntax[] $VALUES;

            private static /* synthetic */ Syntax[] $values() {
                return new Syntax[]{html, xml};
            }

            static {
                $VALUES = Syntax.$values();
            }
        }
    }

    public static final class QuirksMode
    extends Enum<QuirksMode> {
        public static final /* enum */ QuirksMode noQuirks = new QuirksMode();
        public static final /* enum */ QuirksMode quirks = new QuirksMode();
        public static final /* enum */ QuirksMode limitedQuirks = new QuirksMode();
        private static final /* synthetic */ QuirksMode[] $VALUES;

        private static /* synthetic */ QuirksMode[] $values() {
            return new QuirksMode[]{noQuirks, quirks, limitedQuirks};
        }

        static {
            $VALUES = QuirksMode.$values();
        }
    }
}

