/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Logger;
import coursierapi.shaded.coursier.internal.api.ApiHelper;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public final class Cache {
    private ExecutorService pool = ApiHelper.defaultPool();
    private File location = ApiHelper.defaultLocation();
    private Logger logger = null;

    private Cache() {
    }

    public static Cache create() {
        return new Cache();
    }

    public boolean equals(Object object) {
        if (object instanceof Cache) {
            Cache cache = (Cache)object;
            return this.pool.equals(cache.pool) && this.location.equals(cache.location) && Objects.equals(this.logger, cache.logger);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (17 + this.pool.hashCode()) + this.location.hashCode()) + Objects.hashCode(this.logger);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Cache(pool=");
        stringBuilder.append(this.pool.toString());
        stringBuilder.append(", location=");
        stringBuilder.append(this.location.toString());
        if (this.logger != null) {
            stringBuilder.append(", logger=");
            stringBuilder.append(this.logger.toString());
        }
        return stringBuilder.toString();
    }

    public Cache withPool(ExecutorService executorService) {
        this.pool = executorService;
        return this;
    }

    public Cache withLocation(File file) {
        this.location = file;
        return this;
    }

    public Cache withLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public ExecutorService getPool() {
        return this.pool;
    }

    public File getLocation() {
        return this.location;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

