/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.AliasManager;
import com.martiansoftware.nailgun.NGConstants;
import com.martiansoftware.nailgun.NGListeningAddress;
import com.martiansoftware.nailgun.NGSession;
import com.martiansoftware.nailgun.NGSessionPool;
import com.martiansoftware.nailgun.NGUnixDomainServerSocket;
import com.martiansoftware.nailgun.NGWin32NamedPipeServerSocket;
import com.martiansoftware.nailgun.NailStats;
import com.martiansoftware.nailgun.ThreadLocalInputStream;
import com.martiansoftware.nailgun.ThreadLocalPrintStream;
import com.martiansoftware.nailgun.builtins.DefaultNail;
import com.sun.jna.Platform;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NGServer
implements Runnable {
    private Logger LOG;
    public static final int DEFAULT_SESSIONPOOLSIZE = 2;
    private final NGListeningAddress listeningAddress;
    private ServerSocket serversocket;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AliasManager aliasManager;
    private boolean allowNailsByClassName = true;
    private Class defaultNailClass = null;
    private final NGSessionPool sessionPool;
    public PrintStream out;
    public PrintStream err;
    public InputStream in;
    private final Map<String, NailStats> allNailStats;
    private SecurityManager originalSecurityManager = null;
    private final int heartbeatTimeoutMillis;

    public NGServer(InetAddress inetAddress, int n, int n2, int n3) {
        this(new NGListeningAddress(inetAddress, n), n2, n3, System.in, System.out, System.err);
    }

    public NGServer(InetAddress inetAddress, int n) {
        this(new NGListeningAddress(inetAddress, n), 2, 10000, System.in, System.out, System.err);
    }

    public NGServer() {
        this(new NGListeningAddress(null, 2113), 2, 10000, System.in, System.out, System.err);
    }

    public NGServer(NGListeningAddress nGListeningAddress, int n, int n2, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        this(nGListeningAddress, n, n2, inputStream, printStream, printStream2, LoggerFactory.getLogger((String)NGServer.class.getName()));
    }

    public NGServer(NGListeningAddress nGListeningAddress, int n, int n2, InputStream inputStream, PrintStream printStream, PrintStream printStream2, Logger logger) {
        this.listeningAddress = nGListeningAddress;
        this.in = inputStream;
        this.out = printStream;
        this.err = printStream2;
        this.LOG = logger;
        this.aliasManager = new AliasManager();
        this.allNailStats = new HashMap<String, NailStats>();
        this.sessionPool = new NGSessionPool(this, n, this.LOG);
        this.heartbeatTimeoutMillis = n2;
    }

    public void setAllowNailsByClassName(boolean bl) {
        this.allowNailsByClassName = bl;
    }

    public boolean allowsNailsByClassName() {
        return this.allowNailsByClassName;
    }

    public void setDefaultNailClass(Class clazz) {
        this.defaultNailClass = clazz;
    }

    public Class getDefaultNailClass() {
        return this.defaultNailClass == null ? DefaultNail.class : this.defaultNailClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NailStats getOrCreateStatsFor(Class clazz) {
        NailStats nailStats;
        Map<String, NailStats> map = this.allNailStats;
        synchronized (map) {
            String string = clazz.getName();
            nailStats = this.allNailStats.get(string);
            if (nailStats == null) {
                nailStats = new NailStats(string);
                this.allNailStats.put(string, nailStats);
            }
        }
        return nailStats;
    }

    void nailStarted(Class clazz) {
        NailStats nailStats = this.getOrCreateStatsFor(clazz);
        nailStats.nailStarted();
    }

    void nailFinished(Class clazz) {
        NailStats nailStats = this.getOrCreateStatsFor(clazz);
        nailStats.nailFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NailStats> getNailStats() {
        TreeMap<String, NailStats> treeMap = new TreeMap<String, NailStats>();
        Map<String, NailStats> map = this.allNailStats;
        synchronized (map) {
            for (String string : this.allNailStats.keySet()) {
                treeMap.put(string, (NailStats)this.allNailStats.get(string).clone());
            }
        }
        return treeMap;
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public void signalExit() {
        ForkJoinPool.commonPool().submit(() -> this.shutdown(true));
    }

    public void shutdown(boolean bl) {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        try {
            this.serversocket.close();
        }
        catch (Throwable throwable) {
            this.LOG.warn("Exception closing server socket on Nailgun server shutdown", throwable);
        }
        try {
            this.sessionPool.shutdown();
        }
        catch (Throwable throwable) {
            this.LOG.warn("Exception shutting down Nailgun server", throwable);
        }
        System.setIn(this.in);
        System.setOut(this.out);
        System.setErr(this.err);
        if (bl) {
            System.exit(0);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPort() {
        return this.serversocket == null ? this.listeningAddress.getInetPort() : this.serversocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NGSession nGSession;
        block17: {
            this.running.set(true);
            nGSession = null;
            this.originalSecurityManager = System.getSecurityManager();
            InputStream inputStream = System.in;
            synchronized (inputStream) {
                if (!(System.in instanceof ThreadLocalInputStream)) {
                    System.setIn(new ThreadLocalInputStream(this.in));
                    System.setOut(new ThreadLocalPrintStream(this.out));
                    System.setErr(new ThreadLocalPrintStream(this.err));
                }
            }
            try {
                String string;
                if (this.listeningAddress.isInetAddress()) {
                    this.serversocket = this.listeningAddress.getInetAddress() == null ? new ServerSocket(this.listeningAddress.getInetPort()) : new ServerSocket(this.listeningAddress.getInetPort(), 0, this.listeningAddress.getInetAddress());
                } else if (Platform.isWindows()) {
                    boolean bl = true;
                    this.serversocket = new NGWin32NamedPipeServerSocket(this.listeningAddress.getLocalAddress(), bl);
                } else {
                    this.serversocket = new NGUnixDomainServerSocket(this.listeningAddress.getLocalAddress());
                }
                if (this.listeningAddress.isInetAddress() && this.listeningAddress.getInetPort() == 0) {
                    int n = this.getPort();
                    while (n == 0) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        n = this.getPort();
                    }
                    string = ", port " + n;
                } else {
                    string = "";
                }
                this.out.println("NGServer " + NGConstants.VERSION + " started on " + this.listeningAddress.toString() + string + ".");
                while (!this.shutdown.get()) {
                    nGSession = this.sessionPool.take();
                    Socket socket = this.serversocket.accept();
                    nGSession.run(socket);
                }
            }
            catch (Throwable throwable) {
                if (this.shutdown.get()) break block17;
                throwable.printStackTrace();
            }
        }
        if (nGSession != null) {
            nGSession.shutdown();
        }
        this.running.set(false);
    }

    private static void usage() {
        System.err.println("Usage: java com.martiansoftware.nailgun.NGServer");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer port");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer IPAddress");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer IPAddress:port");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer IPAddress:port timeout");
    }

    public static void main(String[] stringArray) throws NumberFormatException, UnknownHostException {
        NGListeningAddress nGListeningAddress;
        Object object;
        Object object2;
        if (stringArray.length > 2) {
            NGServer.usage();
            return;
        }
        int n = 10000;
        if (stringArray.length != 0) {
            object2 = stringArray[0].split(":");
            object = null;
            String string = null;
            if (((String[])object2).length == 2) {
                object = object2[0];
                string = object2[1];
            } else if (object2[0].indexOf(46) >= 0) {
                object = object2[0];
            } else {
                string = object2[0];
            }
            nGListeningAddress = "local".equals(object) && string != null ? new NGListeningAddress(string) : (object != null && string != null ? new NGListeningAddress(InetAddress.getByName((String)object), Integer.parseInt(string)) : (object != null && string == null ? new NGListeningAddress(InetAddress.getByName((String)object), 2113) : new NGListeningAddress(null, Integer.parseInt(string))));
            if (stringArray.length == 2) {
                n = Integer.parseInt(stringArray[1]);
            }
        } else {
            nGListeningAddress = new NGListeningAddress(null, 2113);
        }
        object2 = new NGServer(nGListeningAddress, 2, n, System.in, System.out, System.err);
        object = new Thread((Runnable)object2);
        ((Thread)object).setName("NGServer(" + nGListeningAddress.toString() + ")");
        ((Thread)object).start();
        Runtime.getRuntime().addShutdownHook(new NGServerShutdowner((NGServer)object2));
    }

    public int getHeartbeatTimeout() {
        return this.heartbeatTimeoutMillis;
    }

    private static class NGServerShutdowner
    extends Thread {
        private NGServer server = null;

        NGServerShutdowner(NGServer nGServer) {
            this.server = nGServer;
        }

        @Override
        public void run() {
            this.server.shutdown(false);
            for (int i = 0; this.server.isRunning() && i < 50; ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.server.isRunning()) {
                System.err.println("Unable to cleanly shutdown server.  Exiting JVM Anyway.");
            } else {
                System.out.println("NGServer shut down.");
            }
        }
    }
}

