/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.evaluator.FrameReference;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiObject;
import ch.epfl.scala.debugadapter.internal.evaluator.LocalValue;
import ch.epfl.scala.debugadapter.internal.evaluator.NameTransformer$;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0006\r\u0001eA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K!)\u0001\u0006\u0001C\u0001S!)a\u0006\u0001C\u0001_!)\u0001\n\u0001C\u0001\u0013\")Q\f\u0001C\u0005=\")!\r\u0001C\u0005G\"9A\u000f\u0001b\u0001\n\u0013)\bbBA\u0006\u0001\u0001\u0006IA\u001e\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0005=\u0019\u0016.\u001c9mK\u00163\u0018\r\\;bi>\u0014(BA\u0007\u000f\u0003%)g/\u00197vCR|'O\u0003\u0002\u0010!\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0012%\u0005aA-\u001a2vO\u0006$\u0017\r\u001d;fe*\u00111\u0003F\u0001\u0006g\u000e\fG.\u0019\u0006\u0003+Y\tA!\u001a9gY*\tq#\u0001\u0002dQ\u000e\u00011C\u0001\u0001\u001b!\tYR$D\u0001\u001d\u0015\u0005\u0019\u0012B\u0001\u0010\u001d\u0005\u0019\te.\u001f*fM\u00061An\\4hKJ\u0004\"!\t\u0012\u000e\u0003AI!a\t\t\u0003\r1{wmZ3s\u0003!!Xm\u001d;N_\u0012,\u0007CA\u000e'\u0013\t9CDA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\rQC&\f\t\u0003W\u0001i\u0011\u0001\u0004\u0005\u0006?\r\u0001\r\u0001\t\u0005\u0006I\r\u0001\r!J\u0001\baJ,\u0007/\u0019:f)\r\u0001dg\u0011\t\u00047E\u001a\u0014B\u0001\u001a\u001d\u0005\u0019y\u0005\u000f^5p]B\u00111\u0006N\u0005\u0003k1\u0011!\u0002T8dC24\u0016\r\\;f\u0011\u00159D\u00011\u00019\u0003))\u0007\u0010\u001d:fgNLwN\u001c\t\u0003s\u0001s!A\u000f \u0011\u0005mbR\"\u0001\u001f\u000b\u0005uB\u0012A\u0002\u001fs_>$h(\u0003\u0002@9\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyD\u0004C\u0003E\t\u0001\u0007Q)A\u0003ge\u0006lW\r\u0005\u0002,\r&\u0011q\t\u0004\u0002\u000f\rJ\fW.\u001a*fM\u0016\u0014XM\\2f\u0003!)g/\u00197vCR,Gc\u0001&[9B\u00191J\u0014)\u000e\u00031S!!\u0014\u000f\u0002\tU$\u0018\u000e\\\u0005\u0003\u001f2\u00131\u0001\u0016:z!\t\t\u0006,D\u0001S\u0015\t\u0019F+A\u0002kI&T!!\u0016,\u0002\u0007M,hNC\u0001X\u0003\r\u0019w.\\\u0005\u00033J\u0013QAV1mk\u0016DQaW\u0003A\u0002M\n!\u0002\\8dC24\u0016\r\\;f\u0011\u0015!U\u00011\u0001F\u0003=I7\u000fT8dC24\u0016M]5bE2,GcA\u0013`A\")AI\u0002a\u0001\u000b\")\u0011M\u0002a\u0001q\u0005!a.Y7f\u0003-!\bN]8x\u001fJ<\u0016M\u001d8\u0015\u0007\u0011<\u0017\u000e\u0005\u0002\u001cK&\u0011a\r\b\u0002\u0005+:LG\u000fC\u0003i\u000f\u0001\u0007\u0001(A\u0002ng\u001eDQA[\u0004A\u0002-\f\u0011\u0002\u001e5s_^\f'\r\\3\u0011\u00051\fhBA7p\u001d\tYd.C\u0001\u0014\u0013\t\u0001H$A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001c(!\u0003+ie><\u0018M\u00197f\u0015\t\u0001H$\u0001\u0005sK\u001a$\u0016\u0010]3t+\u00051\bcA<}}6\t\u0001P\u0003\u0002zu\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003wr\t!bY8mY\u0016\u001cG/[8o\u0013\ti\bPA\u0002TKR\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001\u00027b]\u001eT!!a\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0006\u0005\u0011!\u0003:fMRK\b/Z:!\u0003)!WM]3g\u0013\u001a\u0014VM\u001a\u000b\u0006!\u0006E\u0011Q\u0003\u0005\u0007\u0003'Q\u0001\u0019\u0001)\u0002\u000bY\fG.^3\t\u000f\u0005]!\u00021\u0001\u0002\u001a\u00051A\u000f\u001b:fC\u0012\u00042!UA\u000e\u0013\r\tiB\u0015\u0002\u0010)\"\u0014X-\u00193SK\u001a,'/\u001a8dK\u0002")
public class SimpleEvaluator {
    private final Logger logger;
    private final boolean testMode;
    private final Set<String> refTypes;

    public Option<LocalValue> prepare(String expression, FrameReference frame) {
        String encodedExpression = NameTransformer$.MODULE$.encode(expression);
        if (this.isLocalVariable(frame, encodedExpression)) {
            return new Some((Object)new LocalValue(encodedExpression));
        }
        return None$.MODULE$;
    }

    public Try<Value> evaluate(LocalValue localValue, FrameReference frame) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            StackFrame currentFrame = frame.current();
            LocalVariable variable = currentFrame.visibleVariableByName(localValue.name());
            Value rawValue = currentFrame.getValue(variable);
            return this.derefIfRef(rawValue, frame.thread());
        });
    }

    private boolean isLocalVariable(FrameReference frame, String name) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(frame.current().visibleVariables()).asScala()).toList());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List localVariables = (List)success.value();
            return localVariables.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SimpleEvaluator.$anonfun$isLocalVariable$2(name, x$1))).exists((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)SimpleEvaluator.$anonfun$isLocalVariable$3(v)));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.throwOrWarn("Cannot get local variables", exception);
            return false;
        }
        throw new MatchError((Object)try_);
    }

    private void throwOrWarn(String msg, Throwable throwable) {
        String message = new StringBuilder(11).append(msg).append(" because ").append(throwable.getClass().getSimpleName()).append(": ").append(throwable.getMessage()).toString();
        if (this.testMode) {
            throw new Exception(message, throwable);
        }
        this.logger.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
    }

    private Set<String> refTypes() {
        return this.refTypes;
    }

    private Value derefIfRef(Value value, ThreadReference thread) {
        Value value2 = value;
        if (value2 instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value2;
            if (this.refTypes().contains((Object)objectReference.referenceType().name())) {
                return new JdiObject(objectReference, thread).getFieldValue("elem");
            }
        }
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$isLocalVariable$2(String name$1, LocalVariable x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isLocalVariable$3(LocalVariable v) {
        if (!v.isArgument()) return true;
        String string = v.typeName();
        String string2 = "scala.Function0";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public SimpleEvaluator(Logger logger, boolean testMode) {
        this.logger = logger;
        this.testMode = testMode;
        this.refTypes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala.runtime.BooleanRef", "scala.runtime.ByteRef", "scala.runtime.CharRef", "scala.runtime.DoubleRef", "scala.runtime.FloatRef", "scala.runtime.IntRef", "scala.runtime.LongRef", "scala.runtime.ShortRef", "scala.runtime.ObjectRef"}));
    }
}

