/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.IO;
import cats.effect.IO$Async$;
import cats.effect.internals.ArrayStack;
import cats.effect.internals.IOConnection;
import cats.effect.internals.IOConnection$;
import cats.effect.internals.IOFrame;
import cats.effect.internals.IORunLoop;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class IORunLoop$ {
    public static IORunLoop$ MODULE$;
    private final int maxAutoCancelableBatchSize;
    private volatile boolean bitmap$init$0;

    static {
        new IORunLoop$();
    }

    public <A> void start(IO<A> source, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source, IOConnection$.MODULE$.uncancelable(), cb, null, null, null);
    }

    public <A> void startCancelable(IO<A> source, IOConnection conn, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source, conn, cb, null, null, null);
    }

    public void cats$effect$internals$IORunLoop$$loop(IO<Object> source, IOConnection cancelable, Function1<Either<Throwable, Object>, BoxedUnit> cb, IORunLoop.RestartCallback rcbRef, Function1<Object, IO<Object>> bFirstRef, ArrayStack<Function1<Object, IO<Object>>> bRestRef) {
        IO currentIO = source;
        IOConnection conn = cancelable;
        IO.Map bFirst = bFirstRef;
        ArrayStack<Object> bRest = bRestRef;
        IORunLoop.RestartCallback rcb = rcbRef;
        boolean hasUnboxed = false;
        Object unboxed = null;
        int currentIndex = 0;
        do {
            BoxedUnit boxedUnit;
            IO<Object> iO;
            if ((iO = currentIO) instanceof IO.Bind) {
                IO.Bind bind = (IO.Bind)iO;
                IO fa = bind.source();
                Function1 bindNext = bind.f();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                currentIO = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Pure) {
                IO.Pure pure = (IO.Pure)iO;
                Object value = pure.a();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Delay) {
                BoxedUnit boxedUnit2;
                IO.Delay delay = (IO.Delay)iO;
                Function0 thunk = delay.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    currentIO = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    currentIO = new IO.RaiseError(e);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (iO instanceof IO.Suspend) {
                IO.Suspend suspend = (IO.Suspend)iO;
                Function0 thunk = suspend.thunk();
                currentIO = IORunLoop$.liftedTree1$1(thunk);
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.RaiseError) {
                IO.RaiseError raiseError;
                IO.RaiseError raiseError2 = (IO.RaiseError)iO;
                Throwable ex = raiseError2.e();
                IOFrame<Object, IO<Object>> iOFrame = this.findErrorHandler(bFirst, bRest);
                if (iOFrame == null) {
                    cb.apply((Object)package$.MODULE$.Left().apply((Object)ex));
                    return;
                }
                try {
                    raiseError = iOFrame.recover(ex);
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    IO.RaiseError raiseError3 = new IO.RaiseError(e);
                    raiseError = raiseError3;
                }
                IO.RaiseError fa = raiseError;
                bFirst = null;
                currentIO = fa;
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Map) {
                IO.Map map = (IO.Map)iO;
                IO.RaiseError fa = map.source();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = map;
                currentIO = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (iO instanceof IO.Async) {
                    IO.Async async = (IO.Async)iO;
                    if (conn == null) {
                        conn = IOConnection$.MODULE$.apply();
                    }
                    if (rcb == null) {
                        rcb = new IORunLoop.RestartCallback(conn, cb);
                    }
                    rcb.start(async, bFirst, bRest);
                    return;
                }
                if (iO instanceof IO.ContextSwitch) {
                    BoxedUnit boxedUnit5;
                    IO.ContextSwitch contextSwitch = (IO.ContextSwitch)iO;
                    IO next = contextSwitch.source();
                    Function1<IOConnection, IOConnection> modify = contextSwitch.modify();
                    Function4 restore = contextSwitch.restore();
                    IOConnection old = conn != null ? conn : IOConnection$.MODULE$.apply();
                    conn = (IOConnection)modify.apply((Object)old);
                    currentIO = next;
                    if (conn != old) {
                        if (rcb != null) {
                            rcb.contextSwitch(conn);
                        }
                        if (restore != null) {
                            currentIO = new IO.Bind<Object, Object>(next, new IORunLoop.RestoreContext(old, restore));
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit5;
                } else {
                    throw new MatchError(iO);
                }
            }
            if (hasUnboxed) {
                IO iO2;
                Function1<Object, IO<Object>> function1 = this.popNextBind(bFirst, bRest);
                if (function1 == null) {
                    cb.apply((Object)package$.MODULE$.Right().apply(unboxed));
                    return;
                }
                try {
                    iO2 = (IO)function1.apply(unboxed);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable4);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable ex = (Throwable)option.get();
                    IO.RaiseError raiseError = new IO.RaiseError(ex);
                    iO2 = raiseError;
                }
                IO fa = iO2;
                hasUnboxed = false;
                unboxed = null;
                bFirst = null;
                currentIO = fa;
                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
            }
            if (++currentIndex != this.maxAutoCancelableBatchSize) continue;
            if (conn.isCanceled()) {
                return;
            }
            currentIndex = 0;
        } while (true);
    }

    public <A> IO<A> step(IO<A> source) {
        ObjectRef currentIO = ObjectRef.create(source);
        ObjectRef bFirst = ObjectRef.create(null);
        ObjectRef bRest = ObjectRef.create(null);
        boolean hasUnboxed = false;
        ObjectRef unboxed = ObjectRef.create(null);
        do {
            BoxedUnit boxedUnit;
            IO iO;
            if ((iO = (IO)currentIO.elem) instanceof IO.Bind) {
                IO.Bind bind = (IO.Bind)iO;
                IO fa = bind.source();
                Function1 bindNext = bind.f();
                if ((Function1)bFirst.elem != null) {
                    if ((ArrayStack)bRest.elem == null) {
                        bRest.elem = new ArrayStack();
                    }
                    ((ArrayStack)bRest.elem).push((Function1)bFirst.elem);
                }
                bFirst.elem = bindNext;
                currentIO.elem = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Pure) {
                IO.Pure pure = (IO.Pure)iO;
                Object value = pure.a();
                unboxed.elem = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Delay) {
                BoxedUnit boxedUnit2;
                IO.Delay delay = (IO.Delay)iO;
                Function0 thunk = delay.thunk();
                try {
                    unboxed.elem = thunk.apply();
                    hasUnboxed = true;
                    currentIO.elem = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    currentIO.elem = new IO.RaiseError(e);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (iO instanceof IO.Suspend) {
                IO.Suspend suspend = (IO.Suspend)iO;
                Function0 thunk = suspend.thunk();
                currentIO.elem = IORunLoop$.liftedTree2$1(thunk);
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.RaiseError) {
                IO.RaiseError raiseError;
                IO.RaiseError raiseError2 = (IO.RaiseError)iO;
                Throwable ex = raiseError2.e();
                IOFrame<Object, IO<Object>> iOFrame = this.findErrorHandler((Function1<Object, IO<Object>>)((Function1)bFirst.elem), (ArrayStack)bRest.elem);
                if (iOFrame == null) {
                    return (IO)currentIO.elem;
                }
                try {
                    raiseError = iOFrame.recover(ex);
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    IO.RaiseError raiseError3 = new IO.RaiseError(e);
                    raiseError = raiseError3;
                }
                IO.RaiseError fa = raiseError;
                bFirst.elem = null;
                currentIO.elem = fa;
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Map) {
                IO.Map map = (IO.Map)iO;
                IO fa = map.source();
                if ((Function1)bFirst.elem != null) {
                    if ((ArrayStack)bRest.elem == null) {
                        bRest.elem = new ArrayStack();
                    }
                    ((ArrayStack)bRest.elem).push((Function1)bFirst.elem);
                }
                bFirst.elem = map;
                currentIO.elem = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (iO instanceof IO.Async) {
                    return this.suspendAsync((IO.Async)((IO)currentIO.elem), (Function1<Object, IO<Object>>)((Function1)bFirst.elem), (ArrayStack)bRest.elem);
                }
                return new IO.Async((Function2 & Serializable & scala.Serializable)(conn, cb) -> {
                    IORunLoop$.MODULE$.cats$effect$internals$IORunLoop$$loop((IO)currentIO.elem, conn, (Function1<Either<Throwable, Object>, BoxedUnit>)cb, null, (Function1<Object, IO<Object>>)((Function1)bFirst.elem), (ArrayStack)bRest.elem);
                    return BoxedUnit.UNIT;
                }, IO$Async$.MODULE$.apply$default$2());
            }
            if (!hasUnboxed) continue;
            Function1<Object, IO<Object>> function1 = this.popNextBind((Function1<Object, IO<Object>>)((Function1)bFirst.elem), (ArrayStack)bRest.elem);
            if (function1 == null) {
                return (IO)currentIO.elem != null ? (IO)currentIO.elem : new IO.Pure<Object>(unboxed.elem);
            }
            currentIO.elem = IORunLoop$.liftedTree3$1(function1, unboxed);
            hasUnboxed = false;
            unboxed.elem = null;
            bFirst.elem = null;
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        } while (true);
        return null;
    }

    private <A> IO<A> suspendAsync(IO.Async<A> currentIO, Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        return bFirst != null || bRest != null && !bRest.isEmpty() ? new IO.Async((Function2 & Serializable & scala.Serializable)(conn, cb) -> {
            IORunLoop$.MODULE$.cats$effect$internals$IORunLoop$$loop(currentIO, conn, (Function1<Either<Throwable, Object>, BoxedUnit>)cb, null, (Function1<Object, IO<Object>>)bFirst, bRest);
            return BoxedUnit.UNIT;
        }, IO$Async$.MODULE$.apply$default$2()) : currentIO;
    }

    private Function1<Object, IO<Object>> popNextBind(Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        if (bFirst != null && !(bFirst instanceof IOFrame.ErrorHandler)) {
            return bFirst;
        }
        if (bRest == null) {
            return null;
        }
        do {
            Function1<Object, IO<Object>> next;
            if ((next = bRest.pop()) == null) {
                return null;
            }
            if (next instanceof IOFrame.ErrorHandler) continue;
            return next;
        } while (true);
        return null;
    }

    private IOFrame<Object, IO<Object>> findErrorHandler(Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        IOFrame iOFrame;
        Function1<Object, IO<Object>> function1 = bFirst;
        if (function1 instanceof IOFrame) {
            IOFrame iOFrame2;
            iOFrame = iOFrame2 = (IOFrame)function1;
        } else {
            Object v0;
            if (bRest == null) {
                v0 = null;
            } else {
                do {
                    Function1<Object, IO<Object>> ref;
                    if ((ref = bRest.pop()) == null) {
                        return null;
                    }
                    if (!(ref instanceof IOFrame)) continue;
                    return (IOFrame)ref;
                } while (true);
                v0 = null;
            }
            iOFrame = v0;
        }
        return iOFrame;
    }

    private static final IO liftedTree1$1(Function0 thunk$1) {
        IO iO;
        try {
            iO = (IO)thunk$1.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable ex = (Throwable)option.get();
            IO.RaiseError raiseError = new IO.RaiseError(ex);
            iO = raiseError;
        }
        return iO;
    }

    private static final IO liftedTree2$1(Function0 thunk$2) {
        IO iO;
        try {
            iO = (IO)thunk$2.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable ex = (Throwable)option.get();
            IO.RaiseError raiseError = new IO.RaiseError(ex);
            iO = raiseError;
        }
        return iO;
    }

    private static final IO liftedTree3$1(Function1 x1$1, ObjectRef unboxed$1) {
        IO iO;
        try {
            iO = (IO)x1$1.apply(unboxed$1.elem);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable ex = (Throwable)option.get();
            IO.RaiseError raiseError = new IO.RaiseError(ex);
            iO = raiseError;
        }
        return iO;
    }

    private IORunLoop$() {
        MODULE$ = this;
        this.maxAutoCancelableBatchSize = 512;
        this.bitmap$init$0 = true;
    }
}

