import cv2
import numpy as np

def showImg(img):
  # The function cv2.imshow() is used to display an image in a window.
  cv2.imshow('loros detect',img)
  
  # waitKey() waits for a key press to close the window and 0 specifies indefinite loop
  cv2.waitKey(0)
  
  # cv2.destroyAllWindows() simply destroys all the windows we created.
  cv2.destroyAllWindows()
 

img = cv2.imread('loros.jpg')
showImg(img)
#Convert to HSV
hsvImage = cv2.cvtColor(img, cv2.COLOR_BGR2HSV)
#HSV limits
lowerLimit = np.array([95, 0, 0])
upperLimit = np.array([140, 255, 255])

#Create mask from limits
mask = cv2.inRange(hsvImage, lowerLimit, upperLimit)

showImg(mask)

#Apply erode and dilate
kernel = np.ones((5,5), np.uint8) # matriz de 1s de 5x5
mask_eroded = cv2.erode(mask, kernel)
mask_dilated = cv2.dilate(mask, kernel)

showImg(mask_eroded)
showImg(mask_dilated)

#Apply mask
img_masked = cv2.bitwise_and(img, img, mask = mask)

showImg(img_masked)

#Buscar Contours
threshold = 50 # Tiene que ser adecuado al tamanio de la imagen
img_gray = np.copy(img_masked)
img_gray = cv2.cvtColor(img_gray, cv2.COLOR_RGB2GRAY)
showImg(img_gray)
ret, img_threshold = cv2.threshold(img_gray, threshold, 255, type=cv2.THRESH_TRUNC)
showImg(img_threshold)
contours, hierarchy = cv2.findContours(img_threshold, cv2.RETR_TREE, cv2.CHAIN_APPROX_NONE)
img_contoured = np.copy(img)
cv2.drawContours(img_contoured, contours, -1, color=(0,255,0), thickness=8)

showImg(img_contoured)

img_bounding_boxes = np.copy(img)
for contour in contours:
  x, y, w, h = cv2.boundingRect(contour)
  if w*h >= 2000:
    cv2.rectangle(img_bounding_boxes,(x,y),(x+w, y+h),(0,255,0),2)

showImg(img_bounding_boxes)


# The function cv2.imwrite() is used to write an image.
#cv2.imwrite('deteccion_de_figuras.jpg',img_detection)

