#########################################################################################
##################################  Introducción a R #################################### 
#########################################################################################

# Estadistica IN3242 
# profesor: Raimundo Undurraga

# Auxiliares: Matías Reyes, Leonardo Meneses, Bastián Urzúa, Brandon Galarza,
# Antonia Villegas, Camila Jauregui, Francisca Monetta.

# Para borrar todo lo de la consola
rm(list = ls())

#########################################################################################
##################### 1. Creación de Objetos y Clases de Objetos ######################
#########################################################################################

# se Asignan con los simbolos "<-" 

# asignar el valor 12 a n, y el 14 a p
n <- 12 # el que uso más :)
14 -> p

# si el objeto ya existe, el valor se actualiza
n <- 13
15 -> p

# para eliminar objetos del entorno, se usa rm()
rm(n) # elimina el objeto n
rm(p)

# si llamo a n, ya no existe: Error: object 'n' not found
n

# todo objeto tiene 2 carácteristicas.
# Tipo: Numerico, caracter, complejo y lógico (True o false)
# longitud: Numero de elementos del objeto

#Objetos que conocemos: Vectores, arreglos, matrices, listas, etc.


################################### a) Vectores ##################################

# se usa el comando c() para designar una objeto como vector
x <- c(1, 2, 3, 4, 5)

# otra manera es usando assing("x", c())
assign("x", c(1, 2, 3, 4, 5))

# Un vector puede almacenar otros vectores, por ejemplo:
y <- c(x,7, x)

# también se puede tener un vector como condicionales. ej:
u <- x>3

# Cuando un dato no se encuentra disponible se representa como "NA" (Not Available)
# valores numericos infinitos se representan como "inf" y "-inf"
# datos numericos muy grandes se representan con notación exponencial
# Valores que no son numericos se representa como "NaN" (Not a Number)

# ej:
w <- 3/0
w # inf

5^-w # 0

-w # -inf

w-w # NaN

a <- -21000000000
a # -2.1e+10


################################### b) factores ##################################

# un factor incluye los valores a los que le corresponde a una variable categórica
#  y los diferentes niveles posibles de la variable, con la función factor():

factor (x, levels = sort ( unique(x), na.last = TRUE) ,
        labels = levels, exclude = NA, ordered = is.ordered(x))

# Donde levels especifica los posibles niveles del factor (los valores únicos de x),
#exclude indica los valores que se deben excluir de x y ordered es un argumento lógico
# que especifica si los niveles del factor están ordenados (de la tabla anterior vemos
# que x debe ser de tipo numérico o carácter).


################################### c) Matrices ##################################

# Una matriz es un vector, pero que tiene un atributo agregado el cual sería su dimensión
# este atributo define el numero de filas y columnas de una matriz

#ej: matriz de 1x1 con valor NA
matrix(data= NA, nrow = 1, ncol = 1, byrow = FALSE, dimnames = NULL)
# byrow indica si los valores en la data deben llenar
# las columnas de manera sucesiva (FALSE)
# o las filas (TRUE)
# La opcion dimnames hace que asignemos nombres a las filas y columnas.

# más ejemplos

matrix(data= 5, nr=2, nc=2) # matriz de cincos, de 2 x 2
# se podía haber escrito así: matrix(5, 2, 2)

matrix(1:6, 2, 3) # matriz de 2 x 3, con valores del 1 al 6 #por defecto byrow = FALSE
# es decir, equivalente a matrix(1:6, 2, 3, byrow = FALSE)

matrix(1:6, 2, 3, byrow = TRUE) # matriz de 2 x 3, con valores del 1 al 6, pero ahora se
# llena horizontal


################################## d) Data Frames ####################################

# data Frame (marco de datos) # en resumen es una tabla con datos, como las de excel :)
# para crear data frames en R, se ocupa las funciones:
# read.table() # para leer de datos tabulares de otros archivos
# data.frame()
# Estas crean tablas en el entorno de R

# todos los vectores que se incluyan, deben ser de la misma longitud
# en caso de que no sea así, el vector de menor longitud va a repetir sus valores

# ejemplo
x <- 1:4 ; n <- 10 # también se puede separar nuestros objetos (x y n, con ;)
# aquí x es de longitud 4, y n es de logitud 1, así que en el data frame,
# se repetira el valor de n, 4 veces
data.frame(x, n)

# ejemplo
M <- c(10, 35) ; Y <- 2:4
data.frame(M, Y) 
#Error in data.frame(M, Y) : arguments imply differing number of rows: 2, 3
# Aquí la longitud de M no calzan con la de Y cuando se repite.


################################### e) Lista ####################################

# Se crea de manera similar a un data frame a través de la función list()
# y no tienen limitación al tipo de dato que se puede incluir en esta, 
# a diferencia del data frame, los valores de la lista no se toman por defecto del
# nombre de los objetos

# por ejemplo data.frame(x, n) asigna como nombre a sus columnas como x y n
# en cambio lis(x, n) no.
L1 <- list(x, n)
L1
# para asignarle nombres es así:
L2 <- list(Nombre1 = x, Nombre2 = n)
L2

# obtener nombres
names(L1) # NULL, eso porque aún no se asignan a la lista L1

names(L2) # "Nombre1" "Nombre2"



#########################################################################################
#################################### 2. Operadores ######################################
#########################################################################################

# los operadores en R pueden ser lógicos, aritméticos o comparativos

################################## Aritméticos ###################################

# + : suma  
2 + 3

# - : sustracción
5-2

# * : multiplicación;
2*3

# / : división;
6/4

# ^ : potencia
2^3

# %% : módulo
6%%2 # 0
5%%2 # 1
8%%5 # 3

# %/% : division de enteros
6%/%3 # 2
7%/%3 # 2
8%/%3 # 2
9%/%3 # 3


################################## Comparativos ###################################

# estos valores devuelven valores booleanos (TRUE, FALSE)

# < : menor que
# > : mayor que
# <= : menor o igual que
# >= : mayor o igual que
# == : igual
# != : diferente de 

################################## Comparativos ###################################

# ! x : No lógico
# x & y : Y lógico
# x && y : id.
# x | y : O lógico
# x || y : id.
# xor(x, y) : O exclusivo

  
#########################################################################################
########################### 3. Leer e importar Bases de Datos #############################
#########################################################################################

# para leer los archivos en R, es necesario ocuparla dirección de archivo (el path)
# y el formato, puede ser de tipo; .csv , .xls , .xlsx

# para saberen que directorio (ruta del arhivo) estás trabajando, se usa "getwd()"
getwd() # te devuele: "C:/Users/name/Documents" por ejemplo

# para definir el directorio de trabajo, se usa "setwd()"
setwd("D:/OneDrive - Universidad de Chile/Universidad de Chile/FCFM/8vo semestre")
# importante, los slash tienen que ser así " / " y no azá " \ "

# una vez dejado fijo el directorio, se procede a crear el data frame,
# la función más usada es read.table()
# que tiene como argumento obligatorio file, que corresponde al nombre del archivo a leer

# Existen más opciones de argumentos, que por defecto vienen así:

read.table(file, header = FALSE, sep = "", quote = "\"´",
           row.names, col.names, as.is = FALSE, na.strings = "NA",
           colClasses = NA, nwors = -1,
           skip = 0, check.names = TRUE, fill = !blank.lines.skip,
           strip.white = FALSE, blank.lines.skip = TRUE,
           comment.char = "#")

# En general se ocupan los argumentos de file, header, sep, dec y quote,
# file: nombre del archivo, va en " " o como variable de tipo caracter

# header: Varibale logica (FALSE o TRUE) que indica si el archivo contiene el nombre
          # de las variables en la primera fila

# sep : Separador de campo usado en el archivo; por ejemplo sep="\t" si es una tabulación
        # sep = "," si es un archivo separado por comas (csv)

# dec ; caracter usado para representar el punto decimal, (cuidado con los csv 
        # donde generalmente las comas se representan con puntos)

# quote : Para datos alfanumericos, establece el caracter que use usa como delimitador



# Normalmente los archivos a ocupar son formatos del tipo;

# csv, xlx, xlsx

# dado esto, existen paquetes que nos ayudan a leer esta clase de archivos 
# de manera más sencilla. Funciones como;
# read.csv()
# read.csv2()
# read.xlsx()


# ejemplo

# defino el directorio de trabajo
setwd("D:/OneDrive - Universidad de Chile/Universidad de Chile/FCFM/8vo semestre")

# creo el data frame, llamado: mis_datos
mis_datos <- read.csv("datos_tarea1.csv", sep=";", dec=",", header = TRUE)

head(mis_datos) #con esto se logra una minivualización del data frame


#########################################################################################
######################### 4. manipulacion de Bases de Datos ###########################
#########################################################################################

# Para manipular la base de datos debe existir una cierta estructura en el tipo de dato
# para esto existen 3 fucniones que permiten convertir los elementos de un objeto
# a tipo; numerico, logico o caracter. estas funciones son:

as.numeric(x)
as.logical(x)
as.character(x)
# donde x sería nuestro objeto.


# para asegurar la consistencia de los tipos de objetos, es posible realizar modificaciones
# en la base de datos. Las más útiles son:

# detectar la existencia de valores nulos u omitidos (Na o NaN en R) para luego
# eliminarlos, separarlos, descomponerlos, etc, qué hacer con estos valores depende
# mucho del contexto del problema a tratar.

# Estas funciones se explican a continuacion:

# is.na(x) : devuelce TRUE cuando existe valore omitido (NA)
# na.omit(x) : Elimina las observaciones con datos ausentes (NA)
# which(is.nan(x)) : Entrega los indices de los valores con TRUE para (NA)
# split(variable,factor) : Descompone la variable según los factores
# sort() : ordena los datos de menor a mayor
# cbind() : une los elementos de una matriz o vector forma horizontal (por columnas)
# rbind() : une los elementos de una matriz o vector forma vertical (por filas)



#########################################################################################
#################### 5. Distribuciones e inferencia estadistica #######################
#########################################################################################

################################# a) Distribuciones ###################################

# podemos crear datos aleatorios para varias funciones y distribuciones, estas son
# del tipo; rfunc(n, p1, p2)
# donde "func" indica el tipo de distribución
# "n" el numero de datos a generados
# "p1, p2, ...." , indican los valores de los parametros de la distribucion

# algunos tipos de funciones

# rnorm(n, mean=0, sd=1) 
# rexp(n, rate=1)
# rgamma(n, shape, scale =1)

# y así, con todas las distrubiciones que se conocen.

# ejemplo
var_aleatoria <- rnorm(100, 0, 1)
hist(var_aleatoria) # para visualizar la distribución normal


# importante:
# la r en el formato "rfunc" indica distribucion de probabilidad.
# esta r se puede modificar por las letras d, p o q,para obtener;
# densidad de probabilidad: dfunc(x, ....)
# densidad de prob acumulada: pfunc(x, ....)
# valor del cuartil: qfunc(p, ...) con 0<p<1


############################## b) inferencia estadistica #############################

# En R hay muchas maneras de realizar analisis estadisticos, aca se mencionarán los
# más comunes (que se verán en clases posteriores)

# t.test( ) : Inferencia sobre la media en una población
# qqplot( ) : Evaluar gráficamente la hipótesis de que la variable es normal
# shapiro.test( ) : Evaluar la normalidad de la variable a través de un test formal
# wilcox.test( ) : Contrasta si dos muestras proceden de la misma distribución
# sigma.test( ) : Contrastar el valor de la varianza de una variable distribuida normal
# var.test( ) : Lleva a cabo un test F para comparar las varianzas de dos poblaciones



#########################################################################################
############################### # 6. Regresion lineal #################################
#########################################################################################

# Al momento de definir regresiones lineales en R puede ser útil utilizar distintas
# funciones para definir o modificar ciertas variables del modelo, ya sean funciones
# matemáticas (como suma, exponencial, logaritmo, entre otras) 
# y estadísticas (desviación estándar, media, mediana, y más).


# sum(x) : Entrega la suma los elementos de x
# prod(x) : Entrega el producto de los elementos de x
# sqrt(x) : Entrega la raíz cuadrada de x
# log(x) : ntrega el logaritmo natural de x
# exp(x) : Entrega el exponencial de x
# max(x) : Entrega el máximo de los valores en x
# min(x) : Entrega el mínimo de los valores en x
# range(x) : Entrega el rango (diferencia entre el menor y mayor valor) de x o
# c(min(x), max(x))
# length(x) : Entrega la cantidad de elementos de x
# round(x,n) : Entrega el valor de x redondeado a n dígitos
# mean(x) : Entrega el promedio de los valores contenidos en x
# median(x) : Entrega la mediana de los elementos de x
# sd(x) : Entrega la desviación estándar de los valores en x
# var(x) / cov(x) : Entrega la varianza (o matriz de var-cov) de los elementos de x
# cor(x) : Entrega la matriz de correlación de x, si esta es una matriz o un marco de datos
# cor(x, y) : Entrega la correlación lineal entre x e y, o la matriz de 
    # correlación si x e y son matrices o marcos de datos
#which(condición) : Entrega los índices que cumplen con la condición del argumento


# La notación y ~ x es muy común en R, representa a la variable dependiente y, en función de la
#variable independiente x, es decir, expresa la relación entre una variable numérica con otras
#variables predictoras


# para realizar la regresion se ocupa la funcion
# lm() #que viene de liner model

# y la funcion summary() entrega un resumen del modelo con varias de las caracteristicas
# de una regresion



#########################################################################################
############################### # 7. graficos #################################
#########################################################################################

# R presenta una gran variedad de gráficos, por lo que se abarca aquellos gráficos más
# utilizados y útiles para el desarrollo de este curso. 

# plot (x) : Gráfico de los valores de x (en el eje y) ordenados en el eje x
# plot (x,y) : Gráfico bivariado de x (en el eje x) e y (en el eje y)
# boxplot(x) : Gráfico tipo "box-and-whiskers’, o bien, "diagrama de caja y bigotes
# hist (x) : Histograma de las frecuencias de x
# barplot (x) : Histograma de los valores de x
# qqnorm (x) : Cuartiles de x con respecto a lo esperado bajo una distribución normal
# qqline (x) : Recta que pasa por los cuartiles de la distribución y los datos
# qqplot (x,y) : Cuartiles de y con respecto a los cuartiles de x
# dotplot (x,...) : Gráfico de puntos de x, el eje y etiqueta los datos de x, el eje y da su
#                   valor. Permite una selección visual sencilla de todo los elementos con
#                   valores dentro de un determinado rango
# ggplot2 ( ) : Combinación de elementos básicos en gráficos distintos mediante la
#               sintaxis: ggplot(data.frame, aes(x = variable)) + geom_forma( )



#########################################################################################
################################ 8.Descargar paquetes #################################
#########################################################################################


# Para instalar un paquete primero debemos saber el nombre de la librería, por ejemplo
# una librería útil para gráficos es ggplot2. Para instalarla basta con:
install.packages("ggplot2")

# Si queremos una instalación normal con todas sus dependencias:
install.packages("ggplot2", dependencies = T)

# Si queremos los paquetes en .zip podemos guardarlo con el argumento destdir:
install.packages("ineq", destdir = "C:/temp")

#Cuando se instala el paquete para poder usarlo se debe cargar sino no podremos usar las
#funciones asociadas a éstos, para cargarlo podemos escribirlo, por ejemplo, con el paquete
#ggplot2: library(ggplot2)


# readxl : Librería para cargar bases de datos de Excel
# dplyr : Gramática más flexible para manipulación de datos
# car : Para usar el Factor Inflador de Varianza
# Rmisc : Para usar función summarySE()
# gplot2 : Librería para realizar visualizaciones
# xlsx : Librería para cargar bases de datos de Excel
# eachingDemos : Librería para usar la función sigma.test( )
# corrplot : Permite graficar la matriz de correlación
# eda : Métodos de “Exploratory Data Analysis”
# ts : Análisis de series de tiempo
# ctest : Test clásicos (Test de Fisher, T de Student, Pearson, entre otros)
# boot : Métodos de remuestreo y “bootstraping”
# class : Método de clasificación
# cluster : Método de agregación
# nlme : Modelos lineales y no lineales con efectos mixtos
# mgcv : Modelos aditivos generalizados
# nnet : Redes neuronales y modelos multinomiales log-lineales




#########################################################################################
################################### 9.Complementos ####################################
#########################################################################################


# Tenemos ciertos comandos con los cuales tener un mejor entorno en R, ya sea para comenzar
# sin tener objetos de sesiones anteriores, o bien dar un cierto límite de decimales a los cálculos
# que se realicen en R


############## Ejemplo práctico: medallas de países #####################
rm(list = ls()) #limpia el espacio de trabajo

graphics.off() #limpiar graficos

options(digits = 5) #limite de decimales igual a 5

set.seed(1643) #semilla para replicar resultados aleatorios

#setwd("C:\Users\bluea\Documents\IntroR")
setwd("C:/Users/bluea/Documents/IntroR")

library(readxl)
medallas <- read_excel("medallas.xlsx")
View(medallas)


# Obtener una lista de las variables/columnas
variables <- names(medallas)
print(variables)

# Para conocer el tamaño de la data: filas x columnas
dim(medallas)

#summary
summary(medallas)

#histograma medallas de oro
hist(medallas$Oro)

#promedio:
prom <- mean(medallas$Plata, na.rm = TRUE)  # Excluye los valores nulos de lod cálculos
print('Promedio medallas de plata') 
print(prom)

#Desviación estándar
desv <- sd(medallas$Plata, na.rm = TRUE)  # Excluye los valores nulos de lod cálculos
print('Desviación estándar medallas de plata:')
print(desv)


