##### Cargar paquetes

require(ncdf4)      # Trabajar con NetCDF
require(MBC)        # Metodo de escalamiento QDM
require(openxlsx)   # Importar excels
require(lubridate)  # Trabajar con fechas
require(zoo)        # Trabajar con fechas
require(abind)      # Bind matrices
require(hydroGOF)   # Calcular estad?sticos
require(qmap)       # Metodo de escalamiento QM
require(dplyr)      # Reordenar datos
require(reshape)    # Reordenar datos
require(ggplot2)    # Graficas
custom_theme = theme_bw()+theme(legend.title = element_blank(),
                                legend.text = element_text(size = 22),
                                axis.text = element_text(color = "black",size = 21.5),
                                axis.title = element_text(size = 22, color = "black"), 
                                plot.title = element_text(size = 22, color = "black", face = "bold",hjust = 0.5), 
                                legend.position = c(.95, .95),
                                legend.justification = c("right", "top"),
                                legend.box.just = "right",
                                legend.margin = margin(6, 6, 6, 6))
theme_set(custom_theme)
##### Obtener variables de GCM
setwd(getwd())
hist1<-nc_open('1950_1999_cc.nc')
hist2<-nc_open('2000_2005_cc.nc')

t_hist1<-ncvar_get(hist1,'time')
t_hist2<-ncvar_get(hist2,'time')
lat<-ncvar_get(hist1,'lat')
lon<-ncvar_get(hist1,'lon')
pr_hist1<-ncvar_get(hist1,'pr')
pr_hist2<-ncvar_get(hist2,'pr')
nc_close(hist1)
nc_close(hist2)

pry1<-nc_open('2006_2055_cc.nc')
pry2<-nc_open('2056_2100_cc.nc')

t_pry1<-ncvar_get(pry1,'time')
t_pry2<-ncvar_get(pry2,'time')
pr_pry1<-ncvar_get(pry1,'pr')
pr_pry2<-ncvar_get(pry2,'pr')
nc_close(pry1)
nc_close(pry2)

# Juntar los vectores de precipitacion y tiempo para los periodos historicos y de proyeccion

pr_hist<-abind(pr_hist1,pr_hist2)
pr_pry<-abind(pr_pry1,pr_pry2)
t_hist<-c(t_hist1,t_hist2)
t_pry<-c(t_pry1,t_pry2)

# Crear vector de fechas historicas y proyectadas

dates_hist = seq.Date(as.Date("1950-01-01"), as.Date("2005-12-31"), by = "days")
dates_hist <- dates_hist[!(month(dates_hist) == "2" & day(dates_hist) == "29")]

dates_pry = seq.Date(as.Date("2006-01-01"), as.Date("2100-12-31"), by = "days")
dates_pry <- dates_pry[!(month(dates_pry) == "2" & day(dates_pry) == "29")]

# La precipitacion esta en kg m-2 s-1, por lo que hay que transformarla a mm d-1

pr_hist<-pr_hist*86400
pr_pry<-pr_pry*86400

##### Informacion estacion

Datos_Importados <- read.xlsx("Est_Quinta_Normal.xlsx")
Datos_Importados$Fechas <- as.Date(with(Datos_Importados, paste(agno, mes, dia,sep="-")), "%Y-%m-%d")
idx_fechas_estacion_ini<- which(Datos_Importados$Fechas == as.Date("1950-01-01"))
idx_fechas_estacion_fin <- which(Datos_Importados$Fechas == as.Date("2005-12-31"))
Pp_estacion <- Datos_Importados$valor[idx_fechas_estacion_ini:idx_fechas_estacion_fin]
dates_est <- Datos_Importados$Fechas[idx_fechas_estacion_ini:idx_fechas_estacion_fin]

lat_est<- -33.445
lon_est<- 289.317

##### Interpolacion espacial inverso de la distancia

# Primero, se eligen los cuatro pixeles vecinos a la estaci?n

dlat <- lat[2]-lat[1]
dlon <- lon[2]-lon[1]

int_lat<-c(lat_est-dlat,lat_est+dlat)
int_lon<-c(lon_est-dlon,lon_est+dlon)

indices_lat<-which(lat>int_lat[1]&lat<int_lat[2])
indices_lon<-which(lon>int_lon[1]&lon<int_lon[2])

# Se calculan las distancias euclidianas

dist<-array(NA,dim=c(2,2))

for (t in 1:2){
  for (n in 1:2){
    dist[t,n]<-sqrt((lat[indices_lat[t]]-lat_est)^2+(lon[indices_lon[n]]-lon_est)^2)
  }
}

# Se interpola con inverso de la distancia

GCM_Iesp_hist<-NULL # Periodo historico

for (i in 1:length(t_hist)){
  GCM_Iesp_hist[i]<-sum(pr_hist[indices_lon,indices_lat,i]/dist)/sum(dist)
}


GCM_Iesp_pry<-NULL # Periodo futuro

for (i in 1:length(t_pry)){
  GCM_Iesp_pry[i]<-sum(pr_pry[indices_lon,indices_lat,i]/dist)/sum(dist)
}

plot(Pp_estacion,GCM_Iesp_hist) # visualizar lo poco confiables que son los GCMs


##### Escalamiento QDM

# Primero, buscamos el valor de "trace"

Pp_estacion_ord <- sort(Pp_estacion,decreasing=TRUE)
Pp_GCM_ord <- sort(GCM_Iesp_hist,decreasing=TRUE)

ind_tr <- which(Pp_estacion_ord==0)[1]
trace <- Pp_GCM_ord[ind_tr]

# Se aplica QDM y QM por mes
df_proy_esc = data.frame("Fecha" = as.Date("1900-01-01"),
                         "QDM" = NA,
                         "QM" = NA)
for (imes in 1:12) {
  # fechas para el mes iesimo en el periodo historico
  idx_mes_hist = which(month(dates_hist) == imes)
  dates_mes_hist = dates_hist[idx_mes_hist]
  # fechas para el mes iesimo en el periodo proyectado
  idx_mes_proy = which(month(dates_pry) == imes)
  dates_mes_proy = dates_pry[idx_mes_proy]
  # Pp obs, mod hist y mod proy para cada mes
  Pp_estacion_mes = Pp_estacion[idx_mes_hist]
  Pp_GCM_mes_hist <- GCM_Iesp_hist[idx_mes_hist]
  Pp_GCM_mes_pry <- GCM_Iesp_pry[idx_mes_proy]
  # Escalamiento por QDM
  Pp_QDM_mes = QDM(Pp_estacion_mes,
                   Pp_GCM_mes_hist,
                   Pp_GCM_mes_pry,
                   ratio=TRUE,trace=trace)
  # Escalamiento por QM
  QM_fit <-fitQmapQUANT(Pp_estacion_mes,
                        Pp_GCM_mes_hist,
                        wet.day=trace,qstep = 0.1)
  Pp_QM_Mes <- doQmapQUANT(Pp_GCM_mes_pry,
                           QM_fit,
                           type="linear")
  # Crear dataframe con escalamiento
  df_mes_proy_esc_aux = data.frame("Fecha" = dates_mes_proy,
                               "QDM" = Pp_QDM_mes$mhat.p,
                               "QM" = Pp_QM_Mes)
  df_proy_esc = rbind(df_proy_esc, df_mes_proy_esc_aux)
}
df_proy_esc = df_proy_esc[2:nrow(df_proy_esc),]
# Se reasignan las fechas a los resultados
df_proy_esc <- df_proy_esc %>%
  arrange(Fecha)
# Se agrega una columna correspondiente el GCM sin escalar
df_proy_esc$Crudo = GCM_Iesp_pry
# Se grafica para comparar
df_proy_tidy = melt(df_proy_esc, id = "Fecha")
ggplot(df_proy_tidy, aes(Fecha, value, color = variable))+
  geom_line()+
  ylab("Precipitacion [mm/d]")
