# Datos: Dataframe creado con Crear_Data_Frame.R
Mensuales_a_Estacional = function(Datos){
  # Extraer solo los meses en que hay observaciones
  idx_no_nulos = which((is.na(Datos[,2]))==FALSE)
  Datos = Datos[idx_no_nulos,]
  print("Generando serie estacional")
  # Construccion del data frame a llenar con la serie estacional
  Serie_estacional_data = data.frame("Mes"=c("Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre","Enero","Febrero","Marzo"),"Variable"=rep(0,12),"Mes_n"=c(1:12))
  for (i in 1:12) {
    idx_mes_Est = which(month(Datos[,1])==i)
    var_mes_Est = 0
    for (k in idx_mes_Est) {
      var_mes_Est = sum(var_mes_Est,Datos[k,2], na.rm = TRUE)
    }
    if (i > 3) {
      Serie_estacional_data[(i-3),2] = var_mes_Est/length(idx_mes_Est)
    }
    else
      Serie_estacional_data[(i+9),2] = var_mes_Est/length(idx_mes_Est)
  }
  names(Serie_estacional_data)[2] = names(Datos)[2]
  print("Serie estacional creada")
  return(Serie_estacional_data)
}