##Clase con dos valores A y B de cualquier tipo
class Tubo:
    ## Constructor genérico
    ## __init__(None) -> Tubo
    def __init__(self):
        ##definimos los dos extremos
        self.L = []

    ## Tubo.vacio(None) -> Bool
    ## Retorna True si ambos extremos del tubo están vacíos.
    ## De lo contrario, retorna False-
    def vacio(self):
        return (self.L == [])
    
    ## Tubo.ponerA(Any) -> None
    ## Reemplaza el valor A del Tubo por el parámetro ingresado
    def ponerA(self, value):
        self.L.insert(0, value)

    ## Tubo.ponerA(Any) -> None
    ## Reemplaza el valor B del Tubo por el parámetro ingresado
    def ponerB(self, value):
        self.L.append(value)

    ## (Tubo).sacarA(Any) -> Any
    ## Quita y retorna el valor en A
    def sacarA(self):
        assert not self.vacio()
        return self.L.pop(0)

    ## (Tubo).sacarB(Any) -> Any
    ## Quita y retorna el valor en B
    def sacarB(self):
        assert not self.vacio()
        return self.L.pop()

tuba = Tubo()
assert tuba.vacio() 
tuba.ponerA("izquierda")
tuba.ponerB("o derecha?")
tuba.ponerB("tal vez ambas...")
assert not tuba.vacio() 
assert tuba.sacarA() == "izquierda"
assert tuba.sacarA() == "o derecha?"
assert tuba.sacarA() == "tal vez ambas..."
assert tuba.vacio()



