##---------------------------------------------------
## ESTA PARTE NO ESTÁ MODIFICADA
##---------------------------------------------------

#__numerador : int
#__denominador : int
class Fraccion:
  def __init__(self,x=0,y=1):
    if type(x)==str:  #x es string?
       i=x.find("/")    #índice de /
       num=int(x[0:i])  #numerador antes de /   
       den=int(x[i+1:]) #denominador después de /
    elif isinstance(x,Fraccion): #x es Fraccion?
       num=x.__numerador; den=x.__denominador
    else:
       assert type(x)==int and type(y)==int
       num=x; den=y
    #crear e inicializar atributos
    self.__numerador=num
    self.__denominador=den
    assert den != 0
  def __str__(self):
    return str(self.__numerador)+'/'+str(self.__denominador)
  def __add__(self,x): 
    assert isinstance(x,Fraccion) 
    num=self.__numerador * x.__denominador + \
        self.__denominador * x.__numerador
    den=self.__denominador * x.__denominador
    return Fraccion(num,den)
  def comparar(self,x): 
    assert isinstance(x,Fraccion) #x es Fraccion?
    return self.__numerador * x.__denominador   - \
           self.__denominador * x.__numerador
  def __gt__(self,x):
    return self.comparar(x)>0
  def __lt__(self,x):
    return self.comparar(x)<0
  def __eq__(self,x):
    return self.comparar(x)==0
  #__ladd__: Fraccion ->
  #sumar x a self
  #ej: f1 += f2
  def __ladd__(self,x): 
    assert isinstance(x,Fraccion) 
    num=self.__numerador * x.__denominador + \
        self.__denominador * x.__numerador
    den=self.__denominador * x.__denominador
    self.__numerador=num
    self.__denominador=den

  ##---------------------------------------------------
  ## INICIO DE LA PARTE CON LOS MÉTODOS PEDIDOS
  ##---------------------------------------------------


  ## float(Fracción) -> float
  ## retorna el resultado de la fracción como float
  def __float__(self):
    return self.__numerador/self.__denominador
  
  def __floordiv__(self,x):
    assert isinstance(x,Fraccion) 
    return Fraccion(self.__numerador*x.__denominador, x.__numerador*self.__denominador) ##la división entera siempre retorna un entero, así que es válido retornarlo como tal

  def __truediv__(self,x):
    assert isinstance(x,Fraccion) 
    return float(Fraccion(self.__numerador*x.__denominador, x.__numerador*self.__denominador))
  
  def __mul__(self,x):
    assert isinstance(x,Fraccion) 
    return Fraccion(self.__numerador*x.__numerador, self.__denominador*x.__denominador)
  
  def __sub__(self,x):
    assert isinstance(x,Fraccion) 
    num=self.__numerador * x.__denominador - \
        self.__denominador * x.__numerador
    den=self.__denominador * x.__denominador
    return Fraccion(num,den)

#test de clase Fraccion
f1=Fraccion(1,2)
assert str(f1)=='1/2'
f2=Fraccion(1,3)
assert f1 > f2
assert f2 < f1
assert f1+f2 == Fraccion(5,6)
f1 += f2
assert f1 == Fraccion(5,6)

## TESTS DEL ENUNCIADO!!!!!1
f1 = Fraccion(1,2)
f2 = Fraccion(1,3)
assert float(f1) == 0.5
assert float(f2) == 1/3
assert f1*f2 == Fraccion(1,6)
assert f1//f2 == Fraccion(3,2)
assert f1/f2 == 1.5





