#Modelo 2 dimensiones con 3 grados de libertad por nodo.
model BasicBuilder -ndm 2 -ndf 3

#Constantes del problema 

#Creamos los nodos
node 1 0.0 0.0;
node 2 [expr 100.0/4000.0] 100.0;#Se añade una pequeña imperfección para  ver los efectos no lineales
node 11 0.0 0.0; #nodo auxiliar para crear resorte rotaciones

# Creamos las condiciones de borde (restricciones de los apoyos)
# fix $nodeTag (ndf $constrValues)
fix 1 1 1 0; #fijar nodo 1 restringiendo x y pero no la rotación
fix 11 1 1 1; # se restringe los desplazamientos y el giro para tener un giro relativo.

#Material para el resorte
# uniaxialMaterial Elastic $matTag $E <$eta>
uniaxialMaterial Elastic 1 100; # existen más materiales

#Definir la matriz de transformacion geométrica
#geomTransf Linear 1; # Pequeñas deformaciones
#geomTransf PDelta 1; # Efectos por deformaciones de elementos
geomTransf Corotational 3; # Usar en el curso, más compleja y completa, tiene ambos metodos anteriores

#Creamos el elemento
# element elasticBeamColumn $eleTag $iNode $jNode $A $E $Iz $transfTag <-mass $massDens> <-cMass>
element elasticBeamColumn 1 1 2 1500000.0 1500000.0 1500000.0 3; #NO incluye no linealidad del elemento y conecta el nodo 1 con el 2. Área, E, Inercia, Matriz de transformación
# element zeroLength $eleTag $iNode $jNode -mat $matTag1 $matTag2 ... -dir $dir1 $dir2 ...<-doRayleigh $rFlag> <-orient $x1 $x2 $x3 $yp1 $yp2 $yp3>
element zeroLength 2 1 11 -mat 1 -dir 6; # Actua en la direccion 6 giro (Espacio 3D), dado que es un modelo 2D puede actuar en la 3 igual

#Crear patron de carga 
set P -1.0;#
pattern Plain 1 Linear {
   load 2 0.0 $P 0.0
};#patron de carga plano lineal en la dirección y igual a P

#Record para guardar cosas
recorder Node -file NodoDisp2.out -time -node 2 -dof 1 2 3 disp; #guardar los desplazamientos de todos los GDL del nodo 2 en todo el tiempo
recorder Node -file NodoReac2.out -time -node 1 -dof 1 2 3 reaction; #guarda las reacciones del nodo 1

#Definir el análisis 
set dU [expr -0.01];  # Definir  paso control por desplazamientos
integrator DisplacementControl 2 2 $dU;# Controlar el nodo 2 en la dirección y GDL 2 para cada dU
test EnergyIncr 1.0e-15 1000; # Test de convergencia de energía con la tolerancia en 1000 iteraciones
algorithm Newton; # Iterar con el algoritmo de Newton Rhapson
numberer Plain; # Forma de enumerar los nodos
constraints Plain; # Forma de manejar las restricciones
system SparseGeneral; # Forma de definir la matriz de rigidez,etc
analysis Static; # Tipo de análisis
analyze 5000; # 5mil pasos de desplazamiento 0.01









































#Matriz de transformacion geométrica


