%RESULTADOS DE OPENSEES
%Cargar archivos de salida de Opensees
reaccion = load('NodoReac2.out');
disp = load('NodoDisp2.out');
%La carga P viene dado de la reacción del Nodo 1; en el archivo de texto
%los resultados se muestran de acuerdo a las siguientes columnas
%Archivo de reacciones = | CargaP | Reacción en x | Reacción en y | Reacción de Momento|
%Archivo de desplazamientos = | CargaP | displacement en x | en y | rotación|
P = reaccion(:,3);
theta = -disp(:,4);%Se agrega el - para cambiar el sentido de rotación del ángulo

% Resultados teóricos
k = 100;
L = 100;

theta0 = asin(L/4000/L);
Pteorico = k.*(theta-theta0)./(L.*sin(theta));

figure()
hold on;
plot([0 0], [0 1],'LineWidth',2);%Plot carga crítica
plot(theta.*180./pi,Pteorico,'g','LineWidth',1);
plot(theta.*180./pi,P,'r--','LineWidth',1);
grid on; grid minor;
% axis([-1 20 0 1.4]);
title('Carga crítica')
xlabel('Rotación (degrees)');
ylabel('Carga P (kips)');
legend('Carga Crítica','Curva Teórica','OpenSees con imperfección')

