######## Auxiliar 07 - CATALINA SILVA GALAZ ##################################
graphics.off()
rm(list = ls())
cat("\014")

## Definir el directorio general
main_path <- "C:/Users/Lenovo/Documents/Ayudantías/Geo Espacial/Clases/Aux_07/"
setwd(main_path)

## Cargar paquetes 
if(!require(lubridate)){install.packages("lubridate");require(lubridate)}  # Para trabajar con fechas
if(!require(xts)) {install.packages('xts');require(xts)}                   # Para trabajar con fechas
if (!require(zoo)) {install.packages('zoo');require(zoo)}
if (!require(ncdf4)) {install.packages('ncdf4');require(ncdf4)}             # Para trabajar con netcdf
if (!require(reshape)){install.packages('reshape');require(reshape)}         # Modificar estructura de dataframes
if(!require(dplyr)){install.packages('dplyr'); require(dplyr)}             # Modificar estructura de dataframes
if(!require(tidyr)){install.packages('tidyr'); require(tidyr)}             # Modificar estructura de dataframes
if(!require(fields)){install.packages('fields'); require(fields)}             # Para trabajar con rasters y shapes
if(!require(MBC)){install.packages('MBC'); require(MBC)}

options(digits = 5) #cantidad de decimales de R

####Identificar pixel ####
lat_val <- -33.175
lon_val <- -70.475

###########Cargar CR2##################
# Cargar serie historica observada
cr2_path     <- "C:/Users/Lenovo/Documents/CR2MET/"
cr2_name_pr  <- "CR2MET_pr_v2.0_day_1979_2020_005deg.nc"
cr2_name_t   <- "CR2MET_t2m_v2.0_day_1979_2020_005deg.nc"
cr2_pr       <- nc_open(paste0(cr2_path, cr2_name_pr), readunlim = F)
cr2_t        <- nc_open(paste0(cr2_path, cr2_name_t), readunlim = F)
# Visualizamos lo que cargamos desde el netcdf
print(cr2_pr)


# Identificamos limites lat,lon y tiempo en CR2MET
cr2_lats  <- cr2_t$dim$lat$vals
cr2_lon   <- cr2_t$dim$lon$vals
cr2_time  <- cr2_t$dim$time$vals #seconds since 1979-01-01 00:00:00.0
dates_cr2 <- as.Date(as.POSIXct(cr2_time,
                                origin = "1979-01-01"))

# Identificamos resolucion espacial de CR2MET (notar que es regular; i.e., dx = dy)
cr2_resolution <- abs(round(cr2_lats[1]-cr2_lats[2], digits = 2))

# Definimos periodo temporal a evaluar
idx_ini_time    <- which(dates_cr2  == as.Date("1989-01-01")) #identificamos inicio
idx_fin_time    <- which(dates_cr2  == as.Date("2014-12-31")) #identificamos fin
n_time          <- abs(idx_fin_time - idx_ini_time) + 1 #contamos cantidad de dias
dates_cr2met    <- dates_cr2[idx_ini_time:idx_fin_time] #recortamos vector de fechas
n_day           <- length(dates_cr2met) #contamos cantidad de dias en el periodo

# Ubicamos el pixel de interes en la grilla CR2MET
px_lat <- which.min(abs(lat_val - cr2_lats))
px_lon <- which.min(abs(lon_val - cr2_lon))

# Extraccion de 1 pixel del netcdf 
pr_hist_obs = ncvar_get(nc = cr2_pr, varid = "pr",
                             start = c(px_lon, px_lat, idx_ini_time),
                             count = c(1, 1, n_time)) #tomamos un pixel

t2m_hist_obs = ncvar_get(nc = cr2_t, varid = "t2m",
                              start = c(px_lon, px_lat, idx_ini_time),
                              count = c(1, 1, n_time)) #tomamos un pixel

nc_close(cr2_pr)
nc_close(cr2_t)

Matrix_hist_obs <- cbind(pr_hist_obs, t2m_hist_obs)
rm(pr_hist_obs, t2m_hist_obs)
################# Cargar GCM#######################
#Cargar serie histórica modelada
gcm_path       <- main_path
gcm_h_name_pr  <- "pr_day_MIROC6_historical_r1i1p1f1_gn_19890101-20141231_v20191016.nc"
gcm_h_name_t   <- "tas_day_MIROC6_historical_r1i1p1f1_gn_19890101-20141231_v20191016.nc"
gcm_p_name_pr  <- "pr_day_MIROC6_ssp585_r1i1p1f1_gn_20290101-20541231_v20191016.nc"
gcm_p_name_t   <- "tas_day_MIROC6_ssp585_r1i1p1f1_gn_20290101-20591231_v20191016.nc"
gcm_pr_h       <- nc_open(paste0(gcm_path, gcm_h_name_pr))
gcm_tas_h      <- nc_open(paste0(gcm_path, gcm_h_name_t))
gcm_pr_p       <- nc_open(paste0(gcm_path, gcm_p_name_pr))
gcm_tas_p      <- nc_open(paste0(gcm_path, gcm_p_name_t))

print(gcm_tas_h)

pr_hist_mod <- ncvar_get(nc = gcm_pr_h, varid = "pr") #tomamos todo el dominio
t_hist_mod  <- ncvar_get(nc = gcm_tas_h, varid = "tas") #tomamos todo el dominio
pr_proy_mod <- ncvar_get(nc = gcm_pr_p, varid = "pr") #tomamos todo el dominio
t_proy_mod  <- ncvar_get(nc = gcm_tas_p, varid = "tas") #tomamos todo el dominio

nc_close(gcm_pr_h); nc_close(gcm_tas_h)
nc_close(gcm_pr_p); nc_close(gcm_tas_p)

#Limites lat y lon gcm
gcm_lats   <- gcm_pr_h$dim$lat$vals  
gcm_lons   <- gcm_pr_h$dim$lon$vals-360

gcm_time_h <- gcm_pr_h$dim$time$vals #days since 1850-01-01
gcm_time_p <- gcm_pr_p$dim$time$vals #days since 1850-01-01
dates_gcm_h  <- as.Date("1850-01-01") + gcm_time_h
dates_gcm_p  <- as.Date("1850-01-01") + gcm_time_p
dates_gcm    <- c(dates_gcm_h,dates_gcm_p )

gcm_days_h   <- length(dates_gcm_h)
gcm_days_p   <- length(dates_gcm_p)

#identificamos la posición del pixel en la grilla del GCM
gcm_px_lat <- which.min(abs(lat_val - gcm_lats))
gcm_px_lon <- which.min(abs(lon_val - gcm_lons))

cr2_resolution_dy <- abs(round(gcm_lats[1]-gcm_lats[2], digits = 2))
cr2_resolution_dx <- abs(round(gcm_lons[1]-gcm_lons[2], digits = 2))



# Creamos listas con grilla de GCM original recortada al dominio
coarse_grid_t_h <- list(x = gcm_lats[(gcm_px_lat-1):(gcm_px_lat+1)],
                      y = gcm_lons[(gcm_px_lon-1):(gcm_px_lon+1)],
                      z = t_hist_mod[(gcm_px_lon-1):(gcm_px_lon+1),
                                     (gcm_px_lon-1):(gcm_px_lon+1),])

coarse_grid_pr_h <- list(x = gcm_lats[(gcm_px_lat-1):(gcm_px_lat+1)],
                       y = gcm_lons[(gcm_px_lon-1):(gcm_px_lon+1)],
                       z = pr_hist_mod[(gcm_px_lon-1):(gcm_px_lon+1),
                                       (gcm_px_lon-1):(gcm_px_lon+1),])
coarse_grid_t_p <- list(x = gcm_lats[(gcm_px_lat-1):(gcm_px_lat+1)],
                        y = gcm_lons[(gcm_px_lon-1):(gcm_px_lon+1)],
                        z = t_proy_mod[(gcm_px_lon-1):(gcm_px_lon+1),
                                       (gcm_px_lon-1):(gcm_px_lon+1),])

coarse_grid_pr_p <- list(x = gcm_lats[(gcm_px_lat-1):(gcm_px_lat+1)],
                         y = gcm_lons[(gcm_px_lon-1):(gcm_px_lon+1)],
                         z = pr_proy_mod[(gcm_px_lon-1):(gcm_px_lon+1),
                                         (gcm_px_lon-1):(gcm_px_lon+1),])

location_coord <- data.frame(x = lat_val,
                             y = lon_val)
ti <- Sys.time()
#Escalar espacialmente al punto de interes
Esc_esp <- function(dates_gcm, coarse_grid_pr, coarse_grid_t){
for (idays in 1:length(dates_gcm)){   
  
  print(paste0("Interpolando dia ", idays, " de ", length(dates_gcm)))
  
  if (idays == 1){
    InterpDF <- data.frame(Fecha = dates_gcm,
                           pr    = rep(NA, length(dates_gcm)),
                           t2m   = rep(NA, length(dates_gcm)))
  }
  
  # Interpolamos precipitacion al punto de interes
  act_day   <- coarse_grid_pr
  act_day$z <- act_day$z[,,idays]
  InterpDF$pr[idays] <- round(interp.surface(act_day, location_coord) * 86400,
                              digits = 1)  #paso de kg/m2*s a mm
  rm(act_day)
  
  # Interpolamos temperatura al punto de interes
  act_day   <- coarse_grid_t
  act_day$z <- act_day$z[,,idays]
  InterpDF$t2m[idays] <- round(interp.surface(act_day, location_coord) - 273.15,
                               digits = 2) #pasamos de kelvin a °C
  rm(act_day)
  
  #cat("\014")
  
} #idays
  return(InterpDF)
}

#Creamos matrices con series históricas de pr y t escaladas espacialmente
Matrix_hist_mod <- Esc_esp(dates_gcm = dates_gcm_h, coarse_grid_pr = coarse_grid_pr_h,
                           coarse_grid_t = coarse_grid_t_h)

#revisamos las series crudas
plot(Matrix_hist_mod$pr, type= "l")
plot(Matrix_hist_mod$t2m, type= "l")

#Creamos matrices con series proyectadas de pr y t escaladas espacialmente
Matrix_proy_mod <- Esc_esp(dates_gcm = dates_gcm_p, 
                           coarse_grid_pr = coarse_grid_pr_p,
                           coarse_grid_t = coarse_grid_t_p)

#revisamos las series crudas
plot(Matrix_proy_mod$pr, type= "l")
plot(Matrix_proy_mod$t2m, type= "l")


Matrix_mod <- rbind(Matrix_hist_mod[2:3], Matrix_proy_mod[2:3])
tf <- Sys.time()
tf-ti

##############ESCALAMIENTO ESTADÍSTICO -> Corrección de sesgo##################
# Definimos periodos de correccion de sesgo (tamano similar a referencia - 25 yr)

Init_BC_period <- ymd_hms(c("1989-01-01 00:00:00", "2029-01-01 00:00:00"))
End_BC_period  <- ymd_hms(c("2014-12-30 00:00:00", "2054-12-30 00:00:00"))
BC_period      <- length(Init_BC_period)

max_iter <- 30

SaveAux <- array(data = NA, dim = c(length(dates_gcm), 2))

for (mo in 1:12) {
  
  print(paste0("Corrigiendo sesgo en valores de mes ", mo, " de 12 "))
  
  mo_hist       <- month(dates_cr2met) == mo
  
  hist_obs_x_mo <- Matrix_hist_obs[mo_hist,]
  rownames(hist_obs_x_mo) <- NULL
  
  hist_mod_x_mo <- Matrix_hist_obs[mo_hist,]
  rownames(hist_mod_x_mo) <- NULL
  
  id_mo_hist    <- pmatch(dates_cr2met[mo_hist],dates_gcm)
  
  for (iperiod in 1:BC_period){
    
    # Identificamos valores asociados al periodo de interes
    act_period    <- month(dates_gcm) == mo & dates_gcm >= Init_BC_period[iperiod] & dates_gcm <= End_BC_period[iperiod]  
    id_mo_proj    <- pmatch(dates_gcm[act_period],dates_gcm)
    
    proj_mod_x_mo <- Matrix_mod[act_period,]
    rownames(proj_mod_x_mo) <- NULL
    
    #verificamos que no hayan Na
    if (!any(is.na(hist_obs_x_mo)) | 
        !any(is.na(proj_mod_x_mo)) |
        !any(is.na(proj_mod_x_mo))){
      
      pr_trace <- c(0.1)  #para traza fija 
      
      # Definimos naturaleza de variable y traza
      trace     <- c(pr_trace, Inf); 
      ratio.seq <- c(TRUE,FALSE)
      
      ################## Aplicamos MBCn
      fit.bc <- MBCn(o.c   = as.matrix(hist_obs_x_mo), 
                     m.c   = as.matrix(hist_mod_x_mo),
                     m.p   = as.matrix(proj_mod_x_mo),
                     iter  = max_iter,
                     ratio.seq     = ratio.seq, 
                     trace         = trace,
                     trace.calc    = 0.5*trace, 
                     jitter.factor = 0, 
                     n.tau         = NULL,
                     ratio.max     = 2, 
                     ratio.max.trace = 10*trace, 
                     ties            = 'first',
                     qmap.precalc    = FALSE, 
                     silent          = TRUE,
                     n.escore        = 0,
                     subsample       = NULL,
                     pp.type         = 7)
      # Guardamos valores proyectados
      SaveAux[id_mo_proj,] <- fit.bc$mhat.p
      if (iperiod == 1){ #Guardamos periodo historico corregido
        SaveAux[id_mo_hist,] <- fit.bc$mhat.c
      }
      # Eliminamos variable temporal
      rm(fit.bc)
    }else{
      print("ERROR valores na en la serie REVISAR")
      # Completamos con NA
      SaveAux[id_mo_proj,] <- NA
      if (iperiod == 1){ #Guardamos periodo historico corregido
        SaveAux[id_mo_hist,] <- NA}
    }
    
   
    
  } #iperiod
  cat('\014')
} #mo


plot(SaveAux[,1], type= "l")
plot(SaveAux[,2], type= "l")

#redondearmos para disminuir el peso del archivo
SaveAux <- round(SaveAux, digits = 2)

#guardamos las forzantes
savename <- paste0(main_path, 'Forzantes_CC_Pix_',lat_val,'_', lon_val)
write.table(SaveAux, savename, col.names = T, row.names = F, dec = '.', sep = '\t'); rm(savename)


# Estimamos precipitacion traza por mes
#pr_ecdf_obs   <- ecdf(hist_obs_x_mo[,"pr"])
#pbb_obs_trace <- pr_ecdf_obs(min(hist_obs_x_mo[hist_obs_x_mo[,"pr"] > 0,"pr"]))
#pr_ecdf_mod   <- ecdf(hist_mod_x_mo[,"pr"])
#pr_trace      <- as.numeric(quantile(pr_ecdf_mod, probs = pbb_obs_trace))
#pr_trace      <- max(0.1,pr_trace)