# CATALINA SILVA 2022
graphics.off()
rm(list = ls())
cat("\014")

#Definir el directorio general
main_path <- "C:/Users/Lenovo/Documents/Ayudantías/Geo Espacial/Clases/Aux_06/"
setwd(main_path)

#Cargar paquetes
if(!require(lubridate)){install.packages("lubridate");require(lubridate)}  # Para trabajar con fechas
if(!require(xts)) {install.packages('xts');require(xts)}                   # Para trabajar con fechas

if (!require(ncdf4)) {install.packages('ncdf4');require(ncdf4)}             # Para trabajar con netcdf
if (!require(raster)) {install.packages('raster');require(raster)}          # Para trabajar con raster
if (!require(zoo)) {install.packages('zoo');require(zoo)}

if (!require(reshape)){install.packages('reshape');require(reshape)}         # Modificar estructura de dataframes
#if(!require(dplyr)){install.packages('dplyr'); require(dplyr)}             # Modificar estructura de dataframes
#if(!require(tidyr)){install.packages('tidyr'); require(tidyr)}             # Modificar estructura de dataframes

if(!require(tmap)){install.packages('tmap'); require(tmap)}                # Grafica de rasters y shapes
if(!require(rgeos)){install.packages('rgeos'); require(rgeos)}             # Para trabajar con rasters y shapes
if(!require(RColorBrewer)){install.packages('RColorBrewer'); require(RColorBrewer)}

options(digits = 5)
###########Cargar el CR2MET##################

ncdf_path  <- "C:/Users/Lenovo/Documents/CR2MET/"
ncdf_name  <- "CR2MET_pr_v2.0_day_1979_2020_005deg.nc"
ncdf_data  <- nc_open(paste0(ncdf_path, ncdf_name))
print(ncdf_data)


#Cargar shapefile

shape_bas <- shapefile("polygon/polygon.shp")
plot(shape_bas)

###########################Extraccion de valores####################

#Limites lat y lon ncdf

ncdf_lats  <- ncdf_data$dim$lat$vals
ncdf_lon   <- ncdf_data$dim$lon$vals
ncdf_time  <- ncdf_data$dim$time$vals #seconds since 1979-01-01 00:00:00.0
dates_ncdf <- as.Date(as.POSIXct(ncdf_time,
                                 origin = "1979-01-01"))

#Limites lat y lon shapefile
lims_bas  <- extent(shape_bas)
xlim_west <- lims_bas@xmin
xlim_east <- lims_bas@xmax
ylim_south <- lims_bas@ymin
ylim_north <- lims_bas@ymax



# Definimos periodo temporal

idx_ini_time <- which(dates_ncdf  == as.Date("2018-04-01"))
idx_fin_time <- which(dates_ncdf  == as.Date("2020-03-31"))
n_time <- abs(idx_fin_time - idx_ini_time) + 1
dates_cr2met <- dates_ncdf[idx_ini_time:idx_fin_time]
n_day <- length(dates_cr2met)


######################Trabajo a nivel de pixel################ -33.175	-70.475
#Encontramos un pixel dentro de la cuenca
px_lat <- which.min(abs(-33.175 - ncdf_lats))
px_lon <- which.min(abs(-70.475 - ncdf_lon))

# Extraccion de 1 pixel del netcdf 
var_day_cr2met_px = ncvar_get(nc = ncdf_data, varid = "pr",
                              start = c(px_lon, px_lat, idx_ini_time),
                              count = c(1, 1, n_time)) #tomamos un pixel
#nc_close(ncdf_data)
#class(as.numeric(var_day_cr2met_px))

#Calcular ciclo anual
ciclo_anual_Pixel <- function(x) {
  aux <-  rep(NA, 365)
  for (iday in 1:365) {
    idx_day <- which(yday(dates_cr2met) == iday)
    aux[iday] <- mean(x[idx_day], na.rm = T)
  }
  return(aux)
}

ciclo_anual <- ciclo_anual_Pixel(var_day_cr2met_px)
plot(ciclo_anual, type = "l", main = "Ciclo anual de precipitación",
  xlab = "días",ylab = "pr [mm/d]")

#Calcular serie mensual

Serie_mensual_Pixel <- function(x) {
  aux <- as.numeric(apply.monthly(xts(x, dates_cr2met), "sum"))
  return(aux)
}


serie_mensual <- Serie_mensual_Pixel(var_day_cr2met_px)
plot(serie_mensual, type = "l")



######################Trabajo a nivel de cuenca###############
#Extraer los pixeles
# Ubicar limites del shape en netcdf
idx_xlim_west   <- which.min(abs(xlim_west - ncdf_lon))
idx_xlim_east   <- which.min(abs(xlim_east - ncdf_lon))
idx_ylim_south  <- which.min(abs(ylim_south - ncdf_lats))
idx_ylim_north  <- which.min(abs(ylim_north - ncdf_lats))
lons_bas_cr2met <- round(ncdf_lon[idx_xlim_west:idx_xlim_east], digits = 3)
lats_bas_cr2met <- round(ncdf_lats[idx_ylim_south:idx_ylim_north], digits = 3)
n_lats <- abs(idx_ylim_north - idx_ylim_south) + 1
n_lons <- abs(idx_xlim_east - idx_xlim_west) + 1

# Extraccion de netcdf en dominio de la cuenca
var_day_cr2met = ncvar_get(nc = ncdf_data, varid = "pr",
                           start = c(idx_xlim_west, idx_ylim_south, idx_ini_time),
                           count = c(n_lons, n_lats, n_time))
dim(var_day_cr2met)

nc_close(ncdf_data) #cerramos para liberar memoria

##Generar grilla de ncdf
#matrix(NA,8,5) esto es simil a la línea de código sgte (generar la grilla)
# solo tomé valores para que quedara mejor para graficarlo
grid_ncdf <- as.data.frame(var_day_cr2met[, , 10])
colnames(grid_ncdf) <- lats_bas_cr2met
grid_ncdf$lons      <- lons_bas_cr2met
grid_ncdf           <- melt(grid_ncdf, id.var = "lons")
colnames(grid_ncdf) <- c("lon", "lat", "Valor")

# Crear raster
raster_ncdf <- rasterFromXYZ(grid_ncdf)
crs(raster_ncdf) <- crs(shape_bas)


# Graficar este paso es solo para que visualicen lo que estamos haciendo
tm_shape(raster_ncdf) + tm_raster(legend.show = T, palette = brewer.pal("RdYlBu", n = 5)) +
  tm_shape(shape_bas) +
  tm_borders(lty = "solid") +
  tm_layout(panel.label.size = 2,
    main.title  = "Ejemplo pr 2018-04-10",
    main.title.position = "center")

#### Crear raster con fraccion de pixel asociada a la cuenca
raster_frac_bas = rasterize(shape_bas, raster_ncdf, getCover =  T) #obtenemos fraccion de pixel en la cuenca
plot(raster_frac_bas); plot(shape_bas, add = T)
matrix_frac_bas = as.matrix(raster_frac_bas)
matrix_frac_bas = matrix_frac_bas / sum(matrix_frac_bas) #normalizamos
sum(matrix_frac_bas)                                     #para que la suma de 1


#Ciclo anual a nivel de cuenca

var_ciclo_anual_cr2met <- apply(var_day_cr2met, c(1,2), ciclo_anual_Pixel)
var_ciclo_anual_cr2met <- aperm(var_ciclo_anual_cr2met, c(2,3,1))

pr_ciclo_anual_represent <- rep(NA, 365)
for (iday in 1:365) {
  pr_iday_bas <- var_ciclo_anual_cr2met[,,iday]
  pr_iday_bas <- t(pr_iday_bas)
  pr_iday_bas <- pr_iday_bas[nrow(pr_iday_bas):1,]
  pr_ciclo_anual_represent[iday] <- sum(pr_iday_bas*matrix_frac_bas)
}

plot(pr_ciclo_anual_represent, type = "l")

