
######################################
# Bastin Henrquez Jara #############
# Auxiliar demanda de transporte #####
# 2022 ###############################
# Caso de estudio 6 ##################
######################################

# Base para MNL+NL+CNL + LR-test +Test Haussman-McFadden + Test McFadden Variables omitidas


library(maxLik)

############### Multinomial Logit Swissmetro ##############################
rm(list = ls())
#setwd("C:/Caso 6")

SM_dat<-read.delim("swissmetro.dat", header=TRUE, sep="\t")
colnames(SM_dat)[4]<-"id"

#attach(SM_dat) ##### CUANDO SE TRABAJA EN APOLLO NO ES NECESARIO "ATACHEAR", APOLLO LO HACE SOLO (apollo_attach).

## SIEMPRE LIMPIAR BASE DE DATOS PRIMERO
SM_dat<-SM_dat[-which(SM_dat$CHOICE==0),] #Gente que no eligi ninguna alternativa
SM_dat<-SM_dat[(SM_dat$PURPOSE==1) | (SM_dat$PURPOSE==3), ] #dejar slo propsito trabajo
#SM_dat<-SM_dat[SM_dat$GA==0, ] #sacar gente con abono

SM_dat$SM_CO[SM_dat$GA==1]<-0
SM_dat$TRAIN_CO[SM_dat$GA==1]<-0
############### Apollo ################


#install.packages('apollo')
library(apollo)


### Initialise code
apollo_initialise()

### Set core controls
apollo_control = list(
  modelName       = "Swissmetro",
  modelDescr      = "Swissmetro",
  mixing=FALSE,
  indivID         = "id", 
  outputDirectory = "output"
)

### Loading data

database = SM_dat


# ################################################################# #
#### DEFINE MODEL PARAMETERS                                     ####
# ################################################################# #

### Vector of parameters, including any that are kept fixed in estimation
apollo_beta=c(ASC_car=0,
              ASC_train=0,
              ASC_sm=0,
              b_time=0,
              b_cost=0,
              b_fr=0)

### Vector with names (in quotes) of parameters to be kept fixed at their starting value in apollo_beta, use apollo_beta_fixed = c() if none
apollo_fixed = c("ASC_train")


# ################################################################# #
#### GROUP AND VALIDATE INPUTS                                   ####
# ################################################################# #

apollo_inputs = apollo_validateInputs()

# ################################################################# #
#### DEFINE MODEL AND LIKELIHOOD FUNCTION                        ####
# ################################################################# #

apollo_probabilities=function(apollo_beta, apollo_inputs, functionality="estimate"){
  
  ### Attach inputs and detach after function exit
  apollo_attach(apollo_beta, apollo_inputs)
  on.exit(apollo_detach(apollo_beta, apollo_inputs))
  
  ### Create list of probabilities P
  P = list()
  
  ### List of utilities: these must use the same names as in mnl_settings, order is irrelevant
  V = list()
  
  V[["car"]]  = ASC_car+b_time*CAR_TT+b_cost*CAR_CO #car
  V[["train"]]  = ASC_train+b_time*TRAIN_TT+b_cost*TRAIN_CO+b_fr*TRAIN_FR #rail
  V[["SM"]]  = ASC_sm+b_time*SM_TT+b_cost*SM_CO+b_fr*SM_FR  #SwissMetro
  
  ### Define settings for MNL model component
  mnl_settings = list(
    alternatives  = c(SM=2, train=1, car=3), 
    avail         = list(SM=SM_AV, train=TRAIN_AV, car=CAR_AV), 
    choiceVar     = CHOICE,
    utilities     = V
  )
  
  ### Compute probabilities using MNL model
  P[["model"]] = apollo_mnl(mnl_settings, functionality)
  
  P = apollo_panelProd(P, apollo_inputs, functionality) 
  ### Prepare and return outputs of function
  P = apollo_prepareProb(P, apollo_inputs, functionality)
  return(P)
}



# ################################################################# #
#### What does apollo_probabilities return?                      ####
# ################################################################# #

# Run just in case probabilities with beta0 are required
# If probabilities with beta estimated are required, load model and run apollo_probabilities
# with Model$estimate

#apollo_probabilities(apollo_beta, apollo_inputs, functionality="estimate")

# ################################################################# #
#### MODEL ESTIMATION                                            ####
# ################################################################# #

model = apollo_estimate(apollo_beta, apollo_fixed, apollo_probabilities, apollo_inputs)

# ################################################################# #
#### MODEL OUTPUTS                                               ####
# ################################################################# #

apollo_modelOutput(model)

apollo_saveOutput(model)

apollo_sink()


###########################################################
################ NESTED Logit Swissmetro #####################
rm(list=ls())
SM_dat<-read.delim("swissmetro.dat", header=TRUE, sep="\t")
colnames(SM_dat)[4]<-"id"

#attach(SM_dat) ##### CUANDO SE TRABAJA EN APOLLO NO ES NECESARIO "ATACHEAR", APOLLO LO HACE SOLO (apollo_attach).

## SIEMPRE LIMPIAR BASE DE DATOS PRIMERO
SM_dat<-SM_dat[-which(SM_dat$CHOICE==0),] #Gente que no eligi ninguna alternativa
SM_dat<-SM_dat[(SM_dat$PURPOSE==1) | (SM_dat$PURPOSE==3), ] #dejar slo propsito trabajo
#SM_dat<-SM_dat[SM_dat$GA==0, ] #sacar gente con abono

SM_dat$SM_CO[SM_dat$GA==1]<-0
SM_dat$TRAIN_CO[SM_dat$GA==1]<-0

### Initialise code
apollo_initialise()

### Set core controls
apollo_control = list(
  modelName       = "Swissmetro_NL",
  modelDescr      = "Swissmetro_NL",
  mixing=FALSE,
  indivID         = "id", 
  outputDirectory = "output"
)


# ################################################################# #
#### LOAD DATA AND APPLY ANY TRANSFORMATIONS                     ####
# ################################################################# #

### Loading data from package

database = SM_dat


# ################################################################# #
#### DEFINE MODEL PARAMETERS                                     ####
# ################################################################# #

### Vector of parameters, including any that are kept fixed in estimation
apollo_beta=c(ASC_car=0,
              ASC_train=0,
              ASC_sm=0,
              b_tc=0,
              b_tt=0,
              b_tsm=0,
              b_cost=0,
              b_fr=0,
              b_ga=0,
              lambda_classic=1) # 1/mu

### Vector with names (in quotes) of parameters to be kept fixed at their starting value in apollo_beta, use apollo_beta_fixed = c() if none
apollo_fixed = c("ASC_train")


# ################################################################# #
#### GROUP AND VALIDATE INPUTS                                   ####
# ################################################################# #

apollo_inputs = apollo_validateInputs()

# ################################################################# #
#### DEFINE MODEL AND LIKELIHOOD FUNCTION                        ####
# ################################################################# #

apollo_probabilities=function(apollo_beta, apollo_inputs, functionality="estimate"){
  
  
  ### Attach inputs and detach after function exit
  apollo_attach(apollo_beta, apollo_inputs)
  on.exit(apollo_detach(apollo_beta, apollo_inputs))
  
  ### Create list of probabilities P
  P = list()
  
  ### List of utilities: these must use the same names as in mnl_settings, order is irrelevant
  V = list()
  
  V[["car"]]  = ASC_car+b_tc*CAR_TT+b_cost*CAR_CO #car
  V[["train"]]  = ASC_train+b_tt*TRAIN_TT+b_cost*TRAIN_CO+b_fr*TRAIN_FR+b_ga*GA #rail
  V[["SM"]]  = ASC_sm+b_tsm*SM_TT+b_cost*SM_CO+b_fr*SM_FR+b_ga*GA  #SwissMetro
  
  #NESTS
  nlNests      = list(root=1, classic=lambda_classic) #escalas inversas
  
  ### Specify tree structure for NL model
  nlStructure= list()
  nlStructure[["root"]]   = c("SM","classic")
  nlStructure[["classic"]]     = c("train","car")
  
  ### Define settings for NL model
  nl_settings <- list(
    alternatives = c(SM=2, train=1, car=3),
    avail        = list(SM=SM_AV, train=TRAIN_AV, car=CAR_AV),
    choiceVar    = CHOICE,
    utilities    = V,
    nlNests      = nlNests,
    nlStructure  = nlStructure
  )
  ### Compute probabilities using MNL model
  P[["model"]] = apollo_nl(nl_settings, functionality)
  
  P = apollo_panelProd(P, apollo_inputs, functionality) 
  ### Prepare and return outputs of function
  P = apollo_prepareProb(P, apollo_inputs, functionality)
  return(P)
}


# ################################################################# #
#### MODEL ESTIMATION                                            ####
# ################################################################# #

model = apollo_estimate(apollo_beta, apollo_fixed, apollo_probabilities, apollo_inputs)

# ################################################################# #
#### MODEL OUTPUTS                                               ####
# ################################################################# #

apollo_modelOutput(model)

apollo_saveOutput(model)


apollo_sink()



####################################################
############### CROSS NESTED LOGIT #################
####################################################
rm(list=ls())
SM_dat<-read.delim("swissmetro.dat", header=TRUE, sep="\t")
colnames(SM_dat)[4]<-"id"

#attach(SM_dat) ##### CUANDO SE TRABAJA EN APOLLO NO ES NECESARIO "ATACHEAR", APOLLO LO HACE SOLO (apollo_attach).

## SIEMPRE LIMPIAR BASE DE DATOS PRIMERO
SM_dat<-SM_dat[-which(SM_dat$CHOICE==0),] #Gente que no eligi ninguna alternativa
SM_dat<-SM_dat[(SM_dat$PURPOSE==1) | (SM_dat$PURPOSE==3), ] #dejar slo propsito trabajo
#SM_dat<-SM_dat[SM_dat$GA==0, ] #sacar gente con abono

SM_dat$SM_CO[SM_dat$GA==1]<-0
SM_dat$TRAIN_CO[SM_dat$GA==1]<-0

### Initialise code
apollo_initialise()

### Set core controls
apollo_control = list(
  modelName       = "Swissmetro_CNL",
  modelDescr      = "Swissmetro_CNL",
  mixing=FALSE,
  indivID         = "id", 
  outputDirectory = "output"
)


# ################################################################# #
#### LOAD DATA AND APPLY ANY TRANSFORMATIONS                     ####
# ################################################################# #

### Loading data from package

database = SM_dat


# ################################################################# #
#### DEFINE MODEL PARAMETERS                                     ####
# ################################################################# #

### Vector of parameters, including any that are kept fixed in estimation
apollo_beta=c(ASC_car=0,
              ASC_train=0,
              ASC_sm=0,
              b_time=0,
              b_cost=0,
              b_fr=0,
              lambda_Cl=1,
              lambda_RB=1,
              alpha_rail_RB=0.5)

### Vector with names (in quotes) of parameters to be kept fixed at their starting value in apollo_beta, use apollo_beta_fixed = c() if none
apollo_fixed = c("ASC_train")


# ################################################################# #
#### GROUP AND VALIDATE INPUTS                                   ####
# ################################################################# #

apollo_inputs = apollo_validateInputs()

# ################################################################# #
#### DEFINE MODEL AND LIKELIHOOD FUNCTION                        ####
# ################################################################# #

apollo_probabilities=function(apollo_beta, apollo_inputs, functionality="estimate"){
  
  
  ### Attach inputs and detach after function exit
  apollo_attach(apollo_beta, apollo_inputs)
  on.exit(apollo_detach(apollo_beta, apollo_inputs))
  
  ### Create list of probabilities P
  P = list()
  
  ### List of utilities: these must use the same names as in mnl_settings, order is irrelevant
  V = list()
  
  V[["car"]]  = ASC_car+b_time*CAR_TT+b_cost*CAR_CO #car
  V[["train"]]  = ASC_train+b_time*TRAIN_TT+b_cost*TRAIN_CO+b_fr*TRAIN_FR #rail
  V[["SM"]]  = ASC_sm+b_time*SM_TT+b_cost*SM_CO+b_fr*SM_FR  #SwissMetro
  
  
  ### Specify nests for CNL model
  cnlNests = list(RailBased=lambda_RB,Classic=lambda_Cl)
  
  ### Specify nest allocation parameters for alternatives included in multiple nests
  alpha_rail_CL = 1 - alpha_rail_RB
  
  ### Specify tree structure, showing membership in nests (one row per nest, one column per alternative)
  cnlStructure      = matrix(0, nrow=length(cnlNests), ncol=length(V))
  #car  #train   #SM
  cnlStructure[1,] = c( 0,  alpha_rail_RB, 1) # RailBased
  cnlStructure[2,] = c( 1,  alpha_rail_CL, 0) # Classic
  
  ### Define settings for CNL model
  cnl_settings <- list(
    alternatives = c(SM=2, train=1, car=3),
    avail        = list(SM=SM_AV, train=TRAIN_AV, car=CAR_AV),
    choiceVar    = CHOICE,
    utilities    = V,
    cnlNests     = cnlNests,
    cnlStructure = cnlStructure
  )
  
  
  
  ### Compute probabilities using MNL model
  P[["model"]] = apollo_cnl(cnl_settings, functionality)
  
  P = apollo_panelProd(P, apollo_inputs, functionality) 
  ### Prepare and return outputs of function
  P = apollo_prepareProb(P, apollo_inputs, functionality)
  return(P)
}


# ################################################################# #
#### MODEL ESTIMATION                                            ####
# ################################################################# #

model = apollo_estimate(apollo_beta, apollo_fixed, apollo_probabilities, apollo_inputs)

# ################################################################# #
#### MODEL OUTPUTS                                               ####
# ################################################################# #

apollo_modelOutput(model)

apollo_saveOutput(model)


apollo_sink()


#########################################################################
################################## tests ################################
#########################################################################

#Likelihood ratio
#Es necesario haber corrido los dos modelos a comparar, llamemoslos M1 y M2

M1<-apollo_loadModel('modelName1') ## este es el modelo restringido
M2<-apollo_loadModel('modelName2')

apollo_lrTest(M1,M2)  #devuelve chi diferencia de Likelihood y p-value del test

#############################################################
#################### Test Hausman-McFadden ##################
#############################################################

M1<-apollo_loadModel('modelName1') ## Modelo en conjunto restringido
M2<-apollo_loadModel('modelName2') ## Modelo en conjunto completo

varcov1<-M1$varcov
varcov2<-M2$varcov

B1<-M1$estimate
B2<-M2$estimate

K<-length(M1$estimate)#grados de libertad

HM<-t(B1-B2)%*%((varcov1-varcov2)^-1)%*%(B1-B2) #estadstico Hausman-McFadden

Th<-qchisq(0.95,K) #test threshold

# Cumple?
# Si se rechaza la hiptesis nula entonces no se cumple IIA! -> nested u otro
if (HM>=Th){
  print('Se rechaza hiptesis nula con 95% de confianza')
}else{print('No se puede rechazar hiptesis nula')}


print(p<-dchisq(HM, K)) #pvalue para el test

#############################################################
########### Test de variable omitida de McFadden ############
#############################################################

#Estimar primero el modelo, luego leer.

M1<-apollo_loadModel('modelName1')

#calcular utilidades sistemticas

B<-M1$estimate
attach(SM_dat) #base de datos
attach(B)

# COPIAR AC FUNCIONES DE UTILIDAD DADAS A APOLLO
# estas slo como ejemplo

V=list()
V[["car"]]  = ASC_car+b_time*CAR_TT+b_cost*CAR_CO #car
V[["train"]]  = ASC_train+b_time*TRAIN_TT+b_cost*TRAIN_CO+b_fr*TRAIN_FR #rail
V[["SM"]]  = ASC_sm+b_time*SM_TT+b_cost*SM_CO+b_fr*SM_FR  #SwissMetro

#probabilities

P=list()
P[["car"]] =exp(V[["car"]])/(exp(V[["car"]])+exp(V[["train"]])+exp(V[["SM"]] ))
P[["train"]] =exp(V[["train"]])/(exp(V[["car"]])+exp(V[["train"]])+exp(V[["SM"]]))
P[["SM"]] =exp(V[["SM"]])/(exp(V[["car"]])+exp(V[["train"]])+exp(V[["SM"]]))

#auxiliar
# defino conjunto restringido como "train"+"SM"
# es la utilidad esperada al elegir una alternativa dentro del conjunto restringido
Vtilda<-(V[["train"]]*P[["train"]]+V[["SM"]]*P[["SM"]])/(P[["train"]]+P[["SM"]])


Z=list()
Z[["car"]]<-0
Z[["train"]]<-V[["train"]]-Vtilda
Z[["SM"]]<-V[["SM"]]-Vtilda

# Generar base de datos para reestimar modelo

SM_dat2<-cbind(SM_dat,Zcar=Z[["car"]],Ztrain=Z[["train"]],Zsm=Z[["SM"]])

### REESTIMAR CON BASE DE DATOS SM_dat2 e incluir variables "Z" dentro de la utilidad
### Parmetro asociado a Z se llamar gamma
### Leer el nuevo modelo

M2<-apollo_loadModel('modelName2')

apollo_lrTest(M1,M2)  #devuelve chi2, diferencia de Likelihood y p-value del test

## si se rechaza H0, entonces gamma es distinto de 0 y no se cumple IIA!





