import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

public class FormTest {
    private List<String> animeList1= new ArrayList<String>();
    private Form firstForm;
    List<String> animeList2= new ArrayList<String>();
    List<String> nullAnimeList= new ArrayList<String>();
    Form secondForm;
    String nullName;

    @BeforeEach
    public void setUp() {

        animeList1.add("Inuyasha");
        animeList1.add("Doraemon");

        firstForm= new Form("Agnes",7,animeList1);


        animeList2.add("SAO");
        animeList2.add("Erased");
        animeList2.add("Attack on Titan");

        secondForm= new Form("Carlos",25,animeList2);

    }

    @RepeatedTest(100)
    public void ageTest() throws WrongAgeException {
        int newAge= new Random().nextInt(200);
        System.out.print(newAge);
        if (newAge<1) {
            assertThrows(WrongAgeException.class, new Executable() {

                @Override
                public void execute() throws WrongAgeException {
                    firstForm.setAge(newAge);
                }
            });
        }
        else if (newAge>110) {
            assertThrows(WrongAgeException.class, new Executable() {

                @Override
                public void execute() throws WrongAgeException {
                    firstForm.setAge(newAge);
                }
            });
        }
        else {
            firstForm.setAge(newAge);
            assertEquals(newAge, firstForm.getAge());
        }

    }

    @Test
    public void nameTest() throws NullInputException {
        // set name with a null input
        assertThrows(NullInputException.class, new Executable() {

            @Override
            public void execute() throws NullInputException {
                secondForm.setName(nullName);
            }
        });

        // set a valid Name
        String newName="Agnolia";
        secondForm.setName(newName);
        assertEquals(newName, secondForm.getName());
    }

    @Test
    public void topAnimeTest(){
        // TODO implement this test so you can test your own exceptions
    }
}
